package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;

/**
 * <p>
 * Analisador de {@link FormulaParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo frmula. O elemento
 * corrente do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link FormulaParameter}.
 * </p>
 */
public class FormulaParameterFactory extends
  SimpleParameterParser<FormulaParameter> {

  /**
   * Nome do parmetro.
   */
  public static final String FORMULA_PARAMETER_ELEMENT = "formula";

  /**
   * {@inheritDoc}
   */
  @Override
  public FormulaParameter createSimpleParameter(XmlParser parser,
    ParsedSimpleParameter definition, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    return new FormulaParameter(definition.getName(), definition.getLabel(),
      definition.getDescription(), definition.isOptional(), definition
        .isVisible(), definition.getCommandLinePattern());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<FormulaParameter> getParameterStructure() {
    return new SimpleParameterStructure<>(FORMULA_PARAMETER_ELEMENT,
      FormulaParameter.class);
  }

}
