package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerColumn;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.IntegerStructureAttributes;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica para {@link IntegerColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class IntegerColumnFactory extends AbstractTableColumnFactory {

  /**
   * <p>
   * O elemento {@value #ELEMENT_NAME}: descreve uma {@link IntegerColumn coluna
   * do tipo inteiro} de um {@link TableParameter parmetro do tipo tabela}.
   * </p>
   */
  private static final String ELEMENT_NAME = "coluna_de_inteiros";

  /**
   * Cria a fbrica.
   */
  public IntegerColumnFactory() {
    super(ELEMENT_NAME);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setCellValue(XmlParser parser, String parameterName,
    TableColumn<?> column, int rowIndex, String valueAttributeName)
      throws ParseException {
    IntegerColumn integerColumn = (IntegerColumn) column;
    Integer cellValue = parser.extractAttributeValueAsInteger(
      valueAttributeName, null, integerColumn.getMaximum(), integerColumn
        .getMinimum());
    integerColumn.addDefaultValue(rowIndex, cellValue);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected IntegerColumn createColumn(XmlParser parser, String parameterName,
    String label, String id, boolean isOptional, boolean isEditable,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    Integer maximum = parser.extractAttributeValueAsInteger(
      IntegerStructureAttributes.INTEGER_ELEMENT_MAXIMUM_ATTRIBUTE, null,
      null, null);
    Integer minimum = parser.extractAttributeValueAsInteger(
      IntegerStructureAttributes.INTEGER_ELEMENT_MINIMUM_ATTRIBUTE, null,
      maximum, null);
    Integer defaultValue = parser.extractAttributeValueAsInteger(
      COLUMN_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null, maximum, minimum);
    parser.checkAttributes();
    parser.checkChildElements();
    return new IntegerColumn(id, label, defaultValue, isOptional, isEditable,
      maximum, minimum);
  }
}
