package csbase.logic.algorithms.validation;

/**
 * Resultado da validao de um elemento especfico do tipo E.
 * 
 * @param <E> Tipo do elemento validado.
 */
public class ElementValidationResult<E> extends Validation {

  /** O elemento relativo ao resultado em questo */
  E element;

  /**
   * Construtor de resultado que  um grupo. Associa o elemento ao resultado e
   * permite adicionar sub-resultados depois.
   * 
   * @param element o elemento.
   */
  protected ElementValidationResult(E element) {
    this.element = element;
  }

  /**
   * Construtor que incorpora outro resultado (copia) incluindo o elemento
   * relativo ao resultado. O resultado construdo ser grupo ou no, dependendo
   * do que era o resultado incormporado.
   * 
   * @param validation O resultado da validao.
   * @param element O elemento que gerou o resultado.
   */
  protected ElementValidationResult(Validation validation, E element) {
    super(validation);
    this.element = element;
  }

  /**
   * Obtm o elemento relativo ao resultado da validao
   * 
   * @return O elemento
   */
  public E getElement() {
    return element;
  }
}
