/**
 * $Id: ValidationStatus.java 140813 2013-05-10 15:15:06Z fpina $
 */

package csbase.logic.diagnosticservice;

import java.io.Serializable;

/**
 * O estado de uma validao utilizada para obteno do estado de um recurso.
 * 
 * @author Tecgraf PUC-Rio
 */
public class ValidationStatus implements Serializable {
  /**
   * Cdigo do estado da validao.
   */
  public final StatusCode code;
  /**
   * Mensagem da validao.
   */
  public final String message;
  /**
   * Descrio adicional sobre o estado.
   */
  public final String detailMessage;

  /**
   * Construtor.
   * 
   * @param code cdigo do estado
   * @param detailMessage mensagem do estado
   */
  public ValidationStatus(StatusCode code, String detailMessage) {
    this(code, detailMessage, null);
  }

  /**
   * Construtor.
   * 
   * @param code cdigo do estado
   * @param message mensagem do estado
   * @param detailMessage mensagem detalhada (opcional) sobre a mensagem
   */
  public ValidationStatus(StatusCode code, String message, String detailMessage) {
    this.code = code;
    this.message = message;
    this.detailMessage = detailMessage;
  }
}
