package csbase.logic.filetypefinder;

import java.nio.charset.Charset;

import csbase.logic.ClientFile;
import csbase.logic.ProjectFileType;

/**
 * Verificador de tipo de arquivo.
 *
 * @author Tecgraf
 */
public abstract class FileTypeChecker {

  /**
   * Tipo verificado.
   */
  final private ProjectFileType fileType;

  /**
   * Construtor.
   *
   * @param fileType tipo
   */
  public FileTypeChecker(ProjectFileType fileType) {
    if (fileType == null) {
      String err = "Tipo nulo na criao de verificador de tipo de arquivo";
      throw new IllegalArgumentException(err);
    }
    this.fileType = fileType;
  }

  /**
   * Retorna
   *
   * @return fileType
   */
  final public ProjectFileType getFileType() {
    return fileType;
  }

  /**
   * Mtodo de confirmao de tipo de arquivo compatvel com tipo.
   *
   * @param file arquivo
   * @param charset o charset para leitura do arquivo.
   * @return indicativo.
   */
  public final boolean checkType(ClientFile file, Charset charset) {
    /**
     * S precisamos avaliar tipos correspondentes a diretrios, se o arquivo
     * for diretrio. Analogamente, somente precisar avaliar tipos
     * correspondentes a arquivos simples, se o arquivo no for diretrio.
     */
    if ((fileType.isDirectory() && file.isDirectory()) || (!fileType
      .isDirectory() && !file.isDirectory())) {
      return isOfType(file, charset);
    }
    return false;
  }


  /**
   * Mtodo de confirmao especfico do tipo a ser implementado pelas
   * subclasses.
   *
   * @param file arquivo
   * @param charset o charset para leitura do arquivo.
   * @return indicativo.
   */
  abstract protected boolean isOfType(ClientFile file, Charset charset);

}
