/*
 * $Id: OpenProjectNotification.java 116055 2011-03-04 18:15:45Z cassino $
 */
package csbase.logic;

/**
 * Notificao de abertura de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class AbstractProjectRecoveryNotification extends Notification {

  /**
   * Nome do projeto.
   */
  private final String projectName;

  /**
   * Nome do projeto.
   */
  private final Object ownerId;

  /**
   * Retorna: dono do projeto (ver {@link #ownerId})
   * 
   * @return id do dono.
   */
  final public Object getOwnerId() {
    return ownerId;
  }

  /**
   * Obtm o nome do projeto.
   * 
   * @return o nome
   */
  final public String getProjectName() {
    return this.projectName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public boolean isVolatile() {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public boolean getMustPopUp() {
    return true;
  }

  /**
   * Consulta o nome do usurio dono do projeto.
   * 
   * @return nome
   */
  final public String getOwnerName() {
    try {
      return User.getName(ownerId);
    }
    catch (Exception e) {
      return "???";
    }
  }

  /**
   * Consulta o nome do usurio dono do projeto.
   * 
   * @return nome
   */
  final public String getOwnerLogin() {
    try {
      User owner = User.getUser(ownerId);
      return owner.getLogin();
    }
    catch (Exception e) {
      return "???";
    }
  }

  /**
   * Construtor
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param ownerId id do usurio dono do projeto.
   * @param projectName o nome do projeto.
   */
  public AbstractProjectRecoveryNotification(final String sender,
    final Object ownerId, final String projectName) {
    super(sender);
    this.ownerId = ownerId;
    this.projectName = projectName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  abstract public String toString();

}
