package csbase.logic;

/**
 * Permisso para gerenciar algoritmos e reiniciar o servio correspondente.
 * Se um usurio possui essa permisso, ele pode atuar como administrador do
 * sistema para criar gerenciar algoritmos. Esta permisso possui
 * atributos para identificar um ou mais servidores em que o usurio pode
 * interferir. Tb possui atributos do tipo algoritmo=valor que representam
 * os algoritmos que o usuario pode criar/alterar/remove.
 */
public class AlgorithmAdminPermission extends AdminPermission {
  public static final String ALGORITHM_UPDATE = "algoritmo=";
  public AlgorithmAdminPermission() {
    super();
  }
  public AlgorithmAdminPermission(
    String name, String description, String[] attributes) {
    super(name, description, attributes);
  }
}
