/*
 * AlgorithmsReloadNotificationData.java $Author: clinio $ $Revision: 123042 $
 * - $Date: 2011-10-13 19:27:09 -0300 (Thu, 13 Oct 2011) $
 */
package csbase.logic;

/**
 * Classe que modela uma notificao de reload no servio de algoritmos
 * 
 * @author Andr Clinio
 */
public class AlgorithmsReloadNotification extends Notification {
  /**
   * String para auditagem.
   * 
   * @return uma string
   */
  @Override
  public String toString() {
    return "ALGORITHM RELOAD / NOTIFICATION";
  }

  /**
   * Definio da volatilidade da notificao.
   * 
   * @return flag indicativo.
   */
  @Override
  public boolean isVolatile() {
    return true;
  }

  /**
   * Constri o evento de notificao.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   */
  public AlgorithmsReloadNotification(String sender) {
    super(sender);
  }
}
