/**
 * $Id: NewProjectFilesEvent.java 146059 2013-10-22 18:32:34Z fpina $
 */

package csbase.logic;

/**
 * Representa o evento de incluso de vrios arquivos, simultaneamente, na
 * rvore do projeto (para gerar apenas um evento de redesenho). Objetos dessa
 * classe so criados pelo servidor.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class NewProjectFilesEvent extends ProjectEvent {

  /** Caminho do diretrio aonde os arquivos foram criados. */
  private String[][] paths;

  /** Arquivos criados na rvore do projeto. */
  private ClientProjectFile[] files;

  /**
   * Obtm os arquivos criados na rvore do projeto como resultado do evento
   * ocorrido.
   * 
   * @return Os arquivos criados.
   */
  public ClientProjectFile[] getFiles() {
    return files;
  }

  /**
   * Obtm o caminho do diretrio no qual foram criados arquivos como resultado
   * do evento ocorrido.<br>
   * Obs.: estes caminhos so relativos ao diretrio aonde os projetos so
   * armazenados. Em outras palavras, o ancestral mais antigo ser o diretrio
   * do projeto aonde o arquivo foi criado.
   * 
   * @return O caminho do diretrio onde os arquivos foram criados.
   */
  public String[][] getPaths() {
    return paths;
  }

  /**
   * Cria uma instncia de <code>ProjectEvent</code> para o evento de incluso
   * de vrios arquivos na rvore de um projeto.
   * 
   * @param projectId o identificador do projeto sendo atualizado.
   * @param paths Os caminhos do diretrios onde os arquivos foram criados.<br>
   *        Obs.: estes caminhos so relativos ao diretrio aonde os projetos
   *        so armazenados. Em outras palavras, o ancestral mais antigo ser o
   *        diretrio do projeto aonde o arquivo foi criado.
   * @param files os arquivos criados na rvore do projeto como resultado do
   *        evento ocorrido.
   */
  public NewProjectFilesEvent(Object projectId, String[][] paths,
    ClientProjectFile[] files) {
    event = NEW_FILES;
    this.projectId = projectId;
    this.files = files;
    this.paths = paths;
  }
}
