package csbase.logic.algorithms.parameters;

import java.io.Serializable;

import csbase.logic.algorithms.CommandLineContext;

/**
 * <p>
 * Item de enumerao
 * </p>
 * 
 * <p>
 * O item de enumerao  o elemento do parmetro enumerao (
 * {@link EnumerationParameter}). Um item de enumerao possui um identificador,
 * um rtulo e um valor. O identificador  utilizado para criar relacionamentos
 * com outros elementos como gatilhos e enumeraes. O identificador tambm
 * utilizado para verificar a igualdade entre 2 tens de enumerao, ou seja, se
 * 2 tens de enumerao possuem o mesmo identificador eles so considerados
 * iguais. O rtulo  texto que  exibido ao usurio. O valor  o texto que 
 * utilizado na linha de comando.
 * </p>
 * 
 * <p>
 * Um item de enumerao pode ser habilitado/desabilitado.
 * </p>
 * 
 * @author lmoreira
 */
public interface EnumerationItem extends Comparable<EnumerationItem>,
  Serializable {

  /**
   * Obtm a descrio deste item.
   * 
   * @return A descrio ou {@code null} se ela no existir.
   */
  String getDescription();

  /**
   * Obtm o identificador deste item.
   * 
   * @return O identificador.
   */
  String getId();

  /**
   * Obtm o rtulo deste item.
   * 
   * @return O rtulo.
   */
  String getLabel();

  /**
   * Obtm o valor que  utilizado no comando.
   * 
   * @param context O contexto (Aceita {@code null}).
   * 
   * @return O valor.
   */
  String getCommandValue(CommandLineContext context);

  /**
   * Obtm o valor deste item.
   * 
   * @return O valor.
   */
  String getValue();

  /**
   * Indica se um item de enumerao est visvel ({@code true}) ou oculto (
   * {@code false}).
   * 
   * @return {@code true} se estiver visvel ou {@code false} se estiver oculto.
   */
  boolean isVisible();

  /**
   * <p>
   * Exibe/Oculta este item de enumerao.
   * </p>
   * 
   * @param isVisible {@code true} para exibir ou {@code false} para ocultar.
   * 
   * @return {@code true} se mudar o estado ou {@code false} caso contrrio.
   */
  boolean setVisible(boolean isVisible);
}