package csbase.logic.algorithms.parameters;

import java.util.EnumSet;

/**
 * Parmetro que define uma URL de sada.
 *
 * @author Tecgraf
 */
public class OutputURLParameter extends URLParameter {

  /**
   * Indica se o algoritmo permite sadas mltiplas.
   */
  private boolean allowMultipleOutput;

  /**
   * Construtor.
   *
   * @param name nome do parmetro (No aceita {@code null}).
   * @param label rtulo do parmetro (No aceita {@code null}).
   * @param description descrio do parmetro (No aceita {@code null}).
   * @param defaultValue valor-padro (Aceita {@code null}).
   * @param isOptional indica se o valor do parmetro  opcional.
   * @param isVisible indica se o parmetro deve ficar visvel.
   * @param commandLinePattern padro para construo da linha de comando. O
   *        padro ser utilizado para escrever o trecho da linha do comando
   *        referente ao parmetro. Esta string ser passada para o mtodo
   *        MessageFormat.format(String,Object...). O primeiro formato ({0}) 
   *        referente ao nome e o segundo formato ({1})  referente ao valor. Se
   *        {@code null} o parmetro no produzir sada na linha de comando.
   * @param localization define o argumento na linha de comando informando o
   *        protoloco usado pelo usurio.
   * @param fileTypes tipo dos arquivos aceitos neste parmetro (Aceita
   *        {@code null}).
   * @param mode modo do parmetro (No aceita {@code null}).
   * @param usesPipe Indica se este parmetro pode aceitar pipe
   *        {@link FileParameterPipeAcceptance#TRUE}, no aceita pipe
   *        {@link FileParameterPipeAcceptance#FALSE} ou *s* aceita pipe
   *        {@link FileParameterPipeAcceptance#ALWAYS}.
   * @param allowedProtocols conjunto de protocolos aceitos na URL.
   * @param allowMultipleOutput Indica se o algoritmo permite sadas mltiplas.
   */
  public OutputURLParameter(String name, String label, String description,
    FileURLValue defaultValue, boolean isOptional, boolean isVisible,
    String commandLinePattern, String localization, String[] fileTypes,
    FileParameterMode mode, FileParameterPipeAcceptance usesPipe,
    EnumSet<URLProtocol> allowedProtocols, boolean allowMultipleOutput) {
    super(name, label, description, defaultValue, isOptional, isVisible,
      commandLinePattern, localization, fileTypes, mode, usesPipe, false,
      allowedProtocols);
    if (fileTypes != null && fileTypes.length > 1) {
      String errorMessage =
        "Parmetro no aceita mltiplos tipos de arquivo associados.";
      throw new IllegalArgumentException(errorMessage);
    }
    this.allowMultipleOutput = allowMultipleOutput;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getType() {
    return "OUTPUT_URL";
  }

  /**
   *
   * {@inheritDoc}
   */
  @Override
  public boolean isOuput() {
    return true;
  }

  /**
   * Retorna se o algoritmo permite sadas mltiplas
   * 
   * @return Indicativo.
   */
  public boolean allowMultipleOutput() {
    return allowMultipleOutput;
  }
}
