/*
 * $Id$
 */
package csbase.logic.algorithms.parameters.conditions;

import java.util.List;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * Condio "E" (and) para a lista de condies.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class AndOperatorCondition extends CompositeOperatorCondition {

  /**
   * {@inheritDoc}
   * 
   * Mtodo AND: retorna false se alguma condio da lista for {@code false}.
   */
  @Override
  public boolean evaluate(final SimpleAlgorithmConfigurator configurator) {
    for (final Condition condition : getConditions()) {
      if (!condition.evaluate(configurator)) {
        return false;
      }
    }
    return true;
  }

  /**
   * Construtor
   * 
   * @param conditions condies
   */
  public AndOperatorCondition(final Condition... conditions) {
    super(conditions);
  }

  /**
   * Construtor
   * 
   * @param conditions lista de condies
   */
  public AndOperatorCondition(final List<Condition> conditions) {
    super(conditions);
  }
}
