package csbase.logic.algorithms.parsers;

import static csbase.logic.algorithms.parsers.elements.SimpleParameterStructure.PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.DoubleAttribute;

/**
 * <p>
 * Analisador de {@link DoubleParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo real. O elemento corrente
 * do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link DoubleParameter}.
 * </p>
 */
public class DoubleParameterFactory extends
  SimpleParameterParser<DoubleParameter> implements DoubleStructureAttributes {

  /**
   * <p>
   * O elemento {@value #DOUBLE_PARAMETER_ELEMENT}: descreve as propriedades de
   * um {@link DoubleParameter parmetro do tipo real}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String DOUBLE_PARAMETER_ELEMENT = "real";

  /**
   * {@inheritDoc}
   */
  @Override
  public DoubleParameter createSimpleParameter(XmlParser parser,
    ParsedSimpleParameter definition, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {

    Double maximum = definition.getAttributeValue(
      DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE);
    boolean isMaximumIncluded = definition.getAttributeValue(
      DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE);
    Double minimum = definition.getAttributeValue(
      DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE);
    boolean isMinimumIncluded = definition.getAttributeValue(
      DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE);
    DoubleAttribute attribute = (DoubleAttribute) definition.getAttribute(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE);
    attribute.setMinimumValue(minimum);
    attribute.setMaximumValue(maximum);
    Double defaultValue = definition.getAttributeValue(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE);
    //TODO BELLA: Tentar remover
    definition.checkValues();
    return new DoubleParameter(definition.getName(), definition.getLabel(),
      definition.getDescription(), defaultValue, definition.isOptional(),
      definition.isVisible(), definition.getCommandLinePattern(), maximum,
      isMaximumIncluded, minimum, isMinimumIncluded);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<DoubleParameter> getParameterStructure() {
    ParameterStructure<DoubleParameter> doubleStructure = getDoubleStructure(
      DOUBLE_PARAMETER_ELEMENT, DoubleParameter.class);
    doubleStructure.addAttribute(new DoubleAttribute(
      PARAMETER_ELEMENT_DEFAULT_VALUE_ATTRIBUTE, null));
    return doubleStructure;
  }
}
