package csbase.logic.algorithms.parsers.elements;

import java.util.ArrayList;
import java.util.List;

import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.FormulaParameter;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.IntegerListParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;

/**
 * Estrutura de um parmetro.
 */
public class ParameterStructure <T> extends ElementStructure<T> {

  /**
   * <p>
   * O elemento {@value #COMMAND_LINE_PATTERN_ELEMENT}: define o formato da
   * linha de comando para um configurador de algoritmos, para um grupo ou para
   * um parmetro.
   * </p>
   * <p>
   *  elemento filho do configurador de algoritmos, de um grupo ou de um
   * parmetro.
   * </p>
   * <p>
   * O seu valor  opcional e  do tipo string.
   * </p>
   */
  static final String COMMAND_LINE_PATTERN_ELEMENT = "formato_no_comando";

  /**
   * <p>
   * O atributo {@value #PARAMETER_ELEMENT_NAME_ATTRIBUTE} dos elementos:
   * <ul>
   * <li>{@link BooleanParameter}</li>
   * <li>{@link DoubleListParameter}</li>
   * <li>{@link DoubleParameter}</li>
   * <li>{@link EnumerationParameter}</li>
   * <li>{@link FormulaParameter}</li>
   * <li>{@link InputFileParameter}</li>
   * <li>{@link IntegerListParameter}</li>
   * <li>{@link IntegerParameter}</li>
   * <li>{@link OutputFileParameter}</li>
   * <li>{@link TableParameter}</li>
   * <li>{@link TextListParameter}</li>
   * <li>{@link TextParameter}</li>
   * </ul>
   * <p>
   * Indica o nome do parmetro.  obrigatria e o seu tipo  string.
   * </p>
   */
  public static final String PARAMETER_ELEMENT_NAME_ATTRIBUTE = "nome";

  /**
   * Construtor.
   *
   * @param tag nome o parmetro.
   * @param parameterClass classe do parmetro.
   */
  public ParameterStructure(String tag, Class<T> parameterClass) {
    this(tag, parameterClass, new ArrayList<>());
  }

  /**
   * Construtor.
   *
   * @param tag nome o parmetro.
   * @param parameterClass classe do parmetro.
   * @param children lista de elementos filhos.
   */
  public ParameterStructure(String tag, Class<T> parameterClass,
    List<IElementStructure<?>> children) {
    super(tag, parameterClass, children);
    addChild(
      new ElementStructure<>(COMMAND_LINE_PATTERN_ELEMENT, String.class));
    addAttribute(new StringAttribute(PARAMETER_ELEMENT_NAME_ATTRIBUTE));
  }

}
