package csbase.logic.algorithms.parsers.elements.attributes;

import java.io.Serializable;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.ParsedElement;

/**
 * Interface de um atributo de elemento.
 */
public interface IElementAttribute <T> extends Serializable {

  /**
   * Obtm o nome do atributo.
   *
   * @return o nome.
   */
  public String getName();

  /**
   * Obtm o tipo do atributo.
   *
   * @return o tipo.
   */
  public Class<T> getType();

  /**
   * Indica se o atributo  opcional.
   *
   * @return verdadeiro se o atributo for opcional ou falso, caso contrrio.
   */
  public boolean isOptional();

  /**
   * Obtm o valor padro do atributo.
   *
   * @return o valor padro.
   */
  public T getDefaultValue();

  /**
   * Conversor de valor do atributo para string.
   *
   * @return o conversor.
   */
  public StringToValueConverter<T> getValueConverter();

  /**
   * Obtm um outro atributo que servir de valor padro para este atributo.
   *
   * @return o atributo com o valor padro.
   */
  public IElementAttribute<T> getDefaultValueAttribute();

  /**
   * Valida o atributo de acordo com o elemento lido.
   *
   * @param definition o elemento.
   * @return verdadeiro se a validao foi bem sucedida ou falso, caso
   * contrrio.
   * @throws ParseException em caso de erro de leitura do XML.
   */
  public boolean validate(ParsedElement definition) throws ParseException;
}
