/*
 * $Id$
 */
package csbase.logic.algorithms.xml.algorithmspack;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

import csbase.logic.algorithms.AlgorithmsPack;

import tecgraf.javautils.xml.XMLReader;
import tecgraf.javautils.xml.exception.XMLException;

/**
 * Esta classe implementa o leitor XML de arquivos referentes a um pacote de
 * algoritmos.
 * 
 */
public class XmlAlgorithmsPackReader extends XMLReader {

  /** Tamanho do buffer de entrada do leitor */
  final static public int BUFFER_SIZE = 64 * 1024;

  /**
   * Constri um leitor XML para arquivos de pacotes de algoritmos.
   * 
   * @param algorithmsPack pacote de algoritmos
   * @param in stream de entrada
   * @param dtdPath path ou url que identifica o arquivo de dtd
   * @throws XMLException exceo de XML
   */
  public XmlAlgorithmsPackReader(AlgorithmsPack algorithmsPack, InputStream in,
    String dtdPath) throws XMLException {
    super(new BufferedReader(new InputStreamReader(in), BUFFER_SIZE),
      new XmlAlgorithmsPackHandler(algorithmsPack, dtdPath), true);
  }
}