package csbase.logic.server;

/**
 * Representa um evento de remoo de {@link ServerInfo informaes de um
 * servidor} no repositrio.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class ServerInfoRemoveEvent extends ServerInfoEvent {
  /** {@link ServerInfo} removido. */
  private ServerInfo serverInfo;

  /**
   * Cria um evento de remoo de um {@link ServerInfo}.
   *
   * @param source A origem do evento (onde o evento foi gerado).
   * @param serverInfo O {@link ServerInfo} que foi removido.
   */
  public ServerInfoRemoveEvent(Object source, ServerInfo serverInfo) {
    super(ServerInfoEventType.REMOVE);
    this.serverInfo = serverInfo;
  }

  /**
   * Obtm o {@link ServerInfo} que foi removido.
   *
   * @return O {@link ServerInfo} que foi removido.
   */
  public ServerInfo getServerInfo() {
    return this.serverInfo;
  }
}
