/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.ParsedElement;
import csbase.logic.algorithms.parsers.elements.attributes.AbstractElementAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringToValueConverter;

public class DoubleAttribute
extends AbstractElementAttribute<Double> {
    private DoubleAttribute minimumValueAttribute;
    private DoubleAttribute maximumValueAttribute;
    private Double minimumValue;
    private Double maximumValue;

    protected DoubleAttribute(String name, boolean isOptional, Double defaultValue, DoubleAttribute defaultValueAttribute, Double minimumValue, DoubleAttribute minimumValueAttribute, Double maximumValue, DoubleAttribute maximumValueAttribute) {
        super(name, Double.class, isOptional, defaultValue, defaultValueAttribute);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.minimumValueAttribute = minimumValueAttribute;
        this.maximumValueAttribute = maximumValueAttribute;
    }

    public DoubleAttribute(String name, Double defaultValue, Double minimumValue, Double maximumValue) {
        this(name, true, defaultValue, null, minimumValue, null, maximumValue, null);
    }

    public DoubleAttribute(String name, Double defaultValue) {
        this(name, defaultValue, null, null);
    }

    public DoubleAttribute(String name, Double minimumValue, Double maximumValue) {
        this(name, false, null, null, minimumValue, null, maximumValue, null);
    }

    public DoubleAttribute(String name) {
        this(name, null, null);
    }

    public void setMinimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public void setMaximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public void setMaximumValueAttribute(DoubleAttribute maximumValueAttribute) {
        this.maximumValueAttribute = maximumValueAttribute;
    }

    public void setMinimumValueAttribute(DoubleAttribute minimumValueAttribute) {
        this.minimumValueAttribute = minimumValueAttribute;
    }

    @Override
    public boolean validate(ParsedElement definition) throws ParseException {
        return super.validate(definition) && this.validateMaximum(definition) && this.validateMinimum(definition);
    }

    private boolean validateMinimum(ParsedElement definition) throws ParseException {
        Double doubleValue = (Double)definition.getAttributeValue(this.getName());
        if (doubleValue != null) {
            if (this.minimumValueAttribute != null) {
                this.minimumValue = (Double)definition.getAttributeValue(this.minimumValueAttribute.getName());
            }
            if (this.minimumValue != null && doubleValue < this.minimumValue) {
                throw new ParseException("O valor do atributo {1} est\u00e1 abaixo do valor m\u00ednimo permitido.\nValor encontrado: ({2}).\nValor m\u00ednimo: {3}.\n", this.getName(), doubleValue, this.minimumValue);
            }
        }
        return true;
    }

    private boolean validateMaximum(ParsedElement definition) throws ParseException {
        Double doubleValue = (Double)definition.getAttributeValue(this.getName());
        if (doubleValue != null) {
            if (this.maximumValueAttribute != null) {
                this.maximumValue = (Double)definition.getAttributeValue(this.maximumValueAttribute.getName());
            }
            if (this.maximumValue != null && doubleValue > this.maximumValue) {
                throw new ParseException("O valor do atributo {1} est\u00e1 acima do valor m\u00e1ximo permitido.\nValor encontrado: ({2}).\nValor m\u00e1ximo: {3}.\n", this.getName(), doubleValue, this.maximumValue);
            }
        }
        return true;
    }

    @Override
    public StringToValueConverter<Double> getValueConverter() {
        return new StringToDoubleConverter();
    }

    private class StringToDoubleConverter
    implements StringToValueConverter<Double> {
        private StringToDoubleConverter() {
        }

        @Override
        public Double valueOf(String attributeValue) throws ParseException {
            Double doubleValue;
            if (attributeValue == null) {
                return null;
            }
            try {
                doubleValue = new Double(attributeValue);
            }
            catch (NumberFormatException e) {
                throw new ParseException(e, "O valor do atributo {1} do elemento {0} deveria ser um n\u00famero real .\nValor encontrado: ({2}).", DoubleAttribute.this.getName(), attributeValue);
            }
            return doubleValue;
        }
    }
}

