package csbase.logic.algorithms.xml.category;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

import tecgraf.javautils.xml.XMLReader;
import tecgraf.javautils.xml.exception.XMLException;
import csbase.logic.algorithms.CategorySet;

/**
 * Esta classe implementa o leitor XML de arquivos de categorias de algoritmos.
 * 
 */
public class XmlCategoriesReader extends XMLReader {

  /** Tamanho do buffer de entrada do leitor */
  final static public int BUFFER_SIZE = 64 * 1024;

  /**
   * Constri um leitor XML para arquivos de categorias de algoritmos.
   * 
   * @param categorySet conjunto de categorias de algoritmos
   * @param in stream de entrada
   * @throws XMLException exceo de XML
   */
  public XmlCategoriesReader(CategorySet categorySet, InputStream in)
    throws XMLException {
    super(new BufferedReader(new InputStreamReader(in), BUFFER_SIZE),
      new XmlCategoriesHandler(categorySet), false);
  }
}