/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.SyncRemoteFileChannel;
import java.io.IOException;
import java.io.InputStream;
import tecgraf.ftc.common.exception.FailureException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

public class RemoteFileInputStream
extends InputStream {
    private byte[] id = null;
    private SyncRemoteFileChannel channel = null;
    private long mark = -1L;
    private long position = 0L;

    @Override
    public int available() {
        return (int)Math.min(this.channel.getSize() - this.position, Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.close();
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.id = null;
        this.channel = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        byte[] dst = new byte[1];
        try {
            int n = this.channel.syncRead(dst, 0, 1, this.position);
            if (n == 0) {
                return -1;
            }
            return dst[0];
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public int read(byte[] dst) throws IOException {
        return this.read(dst, 0, dst.length);
    }

    @Override
    public int read(byte[] dst, int off, int len) throws IOException {
        try {
            int n = this.channel.syncRead(dst, off, len, this.position);
            if (n == 0) {
                return -1;
            }
            this.position += (long)n;
            return n;
        }
        catch (FailureException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.position = this.mark;
        this.mark = -1L;
    }

    @Override
    public long skip(long n) throws IOException {
        n = Math.min(n, this.channel.getSize() - this.position);
        this.position += n;
        return n;
    }

    public RemoteFileInputStream(RemoteFileChannelInfo info) throws IOException {
        this.id = info.getIdentifier();
        this.channel = new SyncRemoteFileChannel(info);
        try {
            this.channel.open(true);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public RemoteFileInputStream(byte[] id, SyncRemoteFileChannel channel) {
        this.id = id;
        this.channel = channel;
    }

    public String toString() {
        return "RemoteFileInputStream para " + new String(this.id);
    }
}

