/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public final class AlgorithmVersionInfo
implements Comparable<AlgorithmVersionInfo>,
Serializable {
    public static String BIN_DIR = "bin";
    public static final String CONFIGURATOR_DIR = "configurator";
    public static final String DOCUMENTATION_DIR = "html";
    public static final String RELEASE_NOTES_DIR = "notes";
    public static final String HTML_FILE = "index.html";
    public static final String CONFIG_FILE = "config.xml";
    public static final String MONITOR_FILE = "monitor.json";
    public static final String CONFIG_PROPERTIES_FILE = "config.properties";
    public static final String PARAMETERS_PROPERTIES_FILE = "parameters.properties";
    public static final String FLOW_CONFIG_FILE = "config.flx";
    private static final String PROPERTIES_FILE = "config.properties";
    private final AlgorithmConfigurator.ConfiguratorType type;
    private AlgorithmInfo algorithmInfo;
    private List<FileInfo> configurators;
    private String dir;
    private List<FileInfo> documentation;
    private FileInfo releaseNotes;
    private AlgorithmVersionId id;
    private String description;
    public static final String PROPERTY_VALUES_FILE = "version.properties";
    private Map<String, String> propertyValues;
    private Map<String, List<FileInfo>> supportedPlatforms = null;

    public AlgorithmVersionInfo(AlgorithmInfo algorithmInfo, AlgorithmVersionId id, Map<String, List<FileInfo>> supportedPlatforms, Map<String, String> propertyValues, AlgorithmConfigurator.ConfiguratorType type) {
        this(algorithmInfo, supportedPlatforms, type);
        this.id = id;
        int[] numbers = id.getNumbers();
        this.dir = AlgorithmVersionInfo.getDirectoryFor(numbers[0], numbers[1], numbers[2]);
        this.propertyValues = propertyValues;
    }

    public AlgorithmVersionInfo(AlgorithmInfo algorithmInfo, String versionDirName, Map<String, List<FileInfo>> supportedPlatforms, Map<String, String> propertyValues, AlgorithmConfigurator.ConfiguratorType type) {
        this(algorithmInfo, supportedPlatforms, type);
        this.id = AlgorithmVersionInfo.getVersionIdFromDirName(versionDirName);
        int[] numbers = this.id.getNumbers();
        this.dir = AlgorithmVersionInfo.getDirectoryFor(numbers[0], numbers[1], numbers[2]);
        this.propertyValues = propertyValues;
    }

    private AlgorithmVersionInfo(AlgorithmInfo algorithmInfo, Map<String, List<FileInfo>> supportedPlatforms, AlgorithmConfigurator.ConfiguratorType type) {
        this.algorithmInfo = algorithmInfo;
        this.supportedPlatforms = supportedPlatforms;
        this.documentation = new Vector<FileInfo>();
        this.configurators = new Vector<FileInfo>();
        this.type = type;
    }

    public AlgorithmVersionInfo(AlgorithmVersionId id, String description, Map<String, String> propertyValues, AlgorithmConfigurator.ConfiguratorType type) {
        this.id = id;
        this.setDescription(description);
        this.propertyValues = propertyValues;
        this.type = type;
    }

    public static String getDirectoryFor(int major, int minor, int patch) {
        char sep = '_';
        DecimalFormat df = new DecimalFormat("000");
        StringBuffer buf = new StringBuffer("v_");
        buf.append(df.format(major));
        buf.append(sep);
        buf.append(df.format(minor));
        buf.append(sep);
        buf.append(df.format(patch));
        return buf.toString();
    }

    public static Object getIdFromDirectory(String dirName) {
        String[] version = dirName.split("_");
        int major = Integer.parseInt(version[1]);
        int minor = Integer.parseInt(version[2]);
        int patch = Integer.parseInt(version[3]);
        return new AlgorithmVersionId(major, minor, patch);
    }

    public static Object getIdFor(int major, int minor, int patch) {
        return new AlgorithmVersionId(major, minor, patch);
    }

    @Override
    public int compareTo(AlgorithmVersionInfo o) {
        return -1 * this.id.compareTo(o.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmVersionInfo)) {
            return false;
        }
        AlgorithmVersionInfo version = (AlgorithmVersionInfo)obj;
        return this.id.equals(version.id);
    }

    public AlgorithmInfo getInfo() {
        return this.algorithmInfo;
    }

    public void setDocumentation(List<FileInfo> documentation) {
        this.documentation = documentation;
    }

    public void setReleaseNotes(FileInfo releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public void removeDocumentation(FileInfo file) {
        this.documentation.remove(file);
    }

    public void addDocumentation(FileInfo file) {
        if (!this.documentation.contains(file)) {
            this.documentation.add(file);
        }
    }

    public List<FileInfo> getDocumentation() {
        return this.documentation;
    }

    public FileInfo getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setConfigurators(List<FileInfo> configurators) {
        this.configurators = configurators;
    }

    public void removeConfigurator(FileInfo file) {
        this.configurators.remove(file);
    }

    public void addConfigurator(FileInfo file) {
        if (!this.configurators.contains(file)) {
            this.configurators.add(file);
        }
    }

    public List<FileInfo> getConfigurators() {
        return this.configurators;
    }

    public String getBinDirName() {
        return BIN_DIR;
    }

    public String getConfiguratorDirName() {
        return CONFIGURATOR_DIR;
    }

    public String getDocumentationDirName() {
        return DOCUMENTATION_DIR;
    }

    public String getReleaseNotesDirName() {
        return RELEASE_NOTES_DIR;
    }

    public String getDirectory() {
        return this.dir;
    }

    public AlgorithmVersionId getId() {
        return this.id;
    }

    public String getPackageName() {
        return this.algorithmInfo.getDirectory() + "." + "versions" + "." + this.dir + "." + CONFIGURATOR_DIR;
    }

    public Vector<String> getSupportedPlatforms() {
        Vector<String> result = new Vector<String>();
        for (String supportedPlatform : this.supportedPlatforms.keySet()) {
            result.add(supportedPlatform);
        }
        return result;
    }

    public Map<String, List<FileInfo>> getPlatforms() {
        return this.supportedPlatforms;
    }

    public Set<String> getPlatformsNames() {
        return this.supportedPlatforms.keySet();
    }

    public List<FileInfo> getExecutables(String platform) {
        return this.supportedPlatforms.get(platform);
    }

    public void setPlatformExecutables(String platform, List<FileInfo> execs) {
        this.supportedPlatforms.put(platform, execs);
    }

    public void setPlatforms(Hashtable<String, List<FileInfo>> platforms) {
        this.supportedPlatforms = platforms;
    }

    public void setPlatform(String platform) {
        this.supportedPlatforms.put(platform, new Vector());
    }

    public String getVersionsDirName() {
        return "versions";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    public boolean removeExecutable(String platform, FileInfo executable) {
        Collection execs = this.supportedPlatforms.get(platform);
        if (execs != null) {
            return execs.remove(executable);
        }
        return false;
    }

    public String getDirPath() {
        String dirPath = this.algorithmInfo.getAlgorithmRepositoryPath() + "/" + this.algorithmInfo.getDirectory() + "/" + "versions" + "/" + this.dir;
        return dirPath;
    }

    public String getConfiguratorDirPath() {
        String configurationPath = this.getDirPath() + "/" + CONFIGURATOR_DIR;
        return configurationPath;
    }

    public String getExecutableDirPath() {
        String executablePath = this.getDirPath() + "/" + BIN_DIR;
        return executablePath;
    }

    public String getConfiguratorPath() {
        String configurationPath = this.getConfiguratorDirPath() + "/" + CONFIG_FILE;
        return configurationPath;
    }

    public String getMonitorConfigPath() {
        return this.getConfiguratorDirPath() + "/" + MONITOR_FILE;
    }

    public String getFlowConfiguratorPath() {
        String configurationPath = this.getConfiguratorDirPath() + "/" + FLOW_CONFIG_FILE;
        return configurationPath;
    }

    public String getPropertiesPath() {
        String propertiesPath = this.getConfiguratorDirPath() + "/" + "config.properties";
        return propertiesPath;
    }

    public String getDocDirPath() {
        String htmlPath = this.getDirPath() + "/" + DOCUMENTATION_DIR;
        return htmlPath;
    }

    public String getReleaseNotesDirPath() {
        String htmlPath = this.getDirPath() + "/" + RELEASE_NOTES_DIR;
        return htmlPath;
    }

    public String getPlatformPath(String platform) {
        String platPath = this.getDirPath() + "/" + BIN_DIR + "/" + platform;
        return platPath;
    }

    public String getExecFilePath(String platform, String exec) {
        String execPath = this.getPlatformPath(platform) + "/" + exec;
        return execPath;
    }

    private static AlgorithmVersionId getVersionIdFromDirName(String dirName) {
        try {
            StringTokenizer stok = new StringTokenizer(dirName, "_");
            String prefix = stok.nextToken();
            if (!prefix.equals("v")) {
                return null;
            }
            int major = Integer.parseInt(stok.nextToken());
            int minor = Integer.parseInt(stok.nextToken());
            int patch = Integer.parseInt(stok.nextToken());
            return new AlgorithmVersionId(major, minor, patch);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<String, String> getPropertyValues() {
        return this.propertyValues;
    }

    public void setPropertyValues(Hashtable<String, String> propertyValues) {
        this.propertyValues = propertyValues;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public AlgorithmConfigurator.ConfiguratorType getType() {
        return this.type;
    }

    void setInfo(AlgorithmInfo info) {
        this.algorithmInfo = info;
    }
}

