/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.DefaultEnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameterListener;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.validators.EnumerationParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EnumerationListParameter
extends ListParameter<EnumerationItem> {
    public static final String TYPE = "ENUMERATION_LIST";
    private static final Pattern valueAsTextPattern = Pattern.compile("^\\{(.*)\\}:(\\{.*\\})?$");
    private static final Pattern selectedItemsAsTextPattern = Pattern.compile("^(\\{.*\\})$");
    private static final Pattern itemsPattern = Pattern.compile("\\{id=(.*?)/label=(.*?)/value=(.*?)/description=(.*?)/visible=(.*?)\\}");
    private static final String itemAsTextFormat = "{id=%s/label=%s/value=%s/description=%s/visible=%s}";
    private Map<String, EnumerationItem> itemsByLabel = new HashMap<String, EnumerationItem>();
    private List<EnumerationItem> items = new LinkedList<EnumerationItem>();
    private transient List<EnumerationListParameterListener> listeners = new LinkedList<EnumerationListParameterListener>();
    private boolean mustSortItems;

    public EnumerationListParameter(String name, String label, String description, List<EnumerationItem> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern) {
        this(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, false);
    }

    public EnumerationListParameter(String name, String label, String description, List<EnumerationItem> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, boolean mustSortItems) {
        super(name, label, description, defaultValue, isOptional, isVisible, false, true, commandLinePattern);
        this.mustSortItems = mustSortItems;
        this.setEnabled(false);
    }

    public final void addEnumerationListParameterListener(EnumerationListParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public List<EnumerationItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setItems(List<EnumerationItem> items) {
        if (items == null) {
            throw new IllegalArgumentException("O par\u00e2metro items est\u00e1 nulo.");
        }
        this.setValue(null);
        this.items.clear();
        this.itemsByLabel.clear();
        for (EnumerationItem item : items) {
            this.addItem(item);
        }
        if (this.mustSortItems) {
            Collections.sort(this.items);
        }
        this.setEnabled(!items.isEmpty());
        for (EnumerationListParameterListener listener : this.listeners) {
            listener.itemsWereChanged(this);
        }
    }

    @Override
    public boolean setValue(List<EnumerationItem> value) {
        List<EnumerationItem> selectedItems = value;
        if (value != null && this.mustSortItems) {
            selectedItems = new ArrayList<EnumerationItem>(value);
            Collections.sort(selectedItems);
        }
        return super.setValue(selectedItems);
    }

    @Override
    public String getValueAsText() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int inx = 0; inx < this.items.size(); ++inx) {
            EnumerationItem item = this.items.get(inx);
            if (0 < inx) {
                sb.append(',');
            }
            sb.append(this.getItemAsText(item));
        }
        sb.append('}');
        sb.append(':');
        String selectedValues = super.getValueAsText();
        if (null != selectedValues) {
            sb.append(selectedValues);
        }
        return sb.toString();
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue == null) {
            this.setValue(null);
        } else {
            Matcher match = valueAsTextPattern.matcher(parameterValue);
            if (match.find() && 0 < match.groupCount()) {
                String itemList = match.group(1);
                this.setItemsAsText(itemList);
                String selecteds = 2 == match.groupCount() ? match.group(2) : null;
                super.setValueAsText(selecteds);
            } else {
                Matcher itemsMatch = selectedItemsAsTextPattern.matcher(parameterValue);
                if (itemsMatch.find() && itemsMatch.groupCount() == 1) {
                    String selecteds = itemsMatch.group(1);
                    super.setValueAsText(selecteds);
                } else {
                    throw new ParseException("N\u00e3o \u00e9 possivel atribuir o valor\n({0}),j\u00e1 que ele n\u00e3o representa uma codifica\u00e7\u00e3o v\u00e1lida uma lista de itens de enumera\u00e7\u00e3o.\nPar\u00e2metro envolvido: {1}.", parameterValue, this);
                }
            }
        }
    }

    @Override
    protected String getCommandItemValue(CommandLineContext context, EnumerationItem itemValue) {
        if (itemValue == null) {
            return null;
        }
        return itemValue.getCommandValue(context);
    }

    @Override
    public EnumerationItem getItemValueFromText(String itemValue) throws ParseException {
        EnumerationItem item = this.itemsByLabel.get(itemValue);
        if (item == null) {
            throw new ParseException("{0} n\u00e3o \u00e9 identificador de item da enumera\u00e7\u00e3o {1}.\nItems v\u00e1lidos:{2}", itemValue, this, this.getItems());
        }
        return item;
    }

    private boolean addItem(EnumerationItem item) {
        if (item == null) {
            throw new IllegalArgumentException("O par\u00e2metro item est\u00e1 nulo.");
        }
        if (this.itemsByLabel.containsKey(item.getLabel())) {
            return false;
        }
        this.itemsByLabel.put(item.getLabel(), item);
        this.items.add(item);
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<EnumerationListParameterListener>();
    }

    private String getItemAsText(EnumerationItem item) {
        String id = item.getId() == null ? "" : item.getId();
        String label = item.getLabel() == null ? "" : item.getLabel();
        String value = item.getValue() == null ? "" : item.getValue();
        String description = item.getDescription() == null ? "" : item.getDescription();
        String visible = Boolean.toString(item.isVisible());
        return String.format(itemAsTextFormat, id, label, value, description, visible);
    }

    private void setItemsAsText(String itemsAsText) throws ParseException {
        ArrayList<EnumerationItem> itemList = new ArrayList<EnumerationItem>();
        Matcher matcher = itemsPattern.matcher(itemsAsText);
        while (matcher.find()) {
            if (matcher.groupCount() == 5) {
                String id = matcher.group(1);
                String label = matcher.group(2);
                String value = matcher.group(3);
                String description = matcher.group(4);
                boolean visible = Boolean.valueOf(matcher.group(5));
                DefaultEnumerationItem item = new DefaultEnumerationItem(id, label, value, description);
                item.setVisible(visible);
                itemList.add(item);
                continue;
            }
            throw new ParseException("N\u00e3o \u00e9 possivel atribuir o valor\n({0}),j\u00e1 que ele n\u00e3o representa uma codifica\u00e7\u00e3o v\u00e1lida para itens de enumera\u00e7\u00e3o.\nPar\u00e2metro envolvido: {1}.", matcher.group(0), this);
        }
        this.setItems(itemList);
    }

    public boolean mustSortItems() {
        return this.mustSortItems;
    }

    @Override
    protected SimpleParameterValidator<EnumerationItem> createItemValidator() {
        return new EnumerationParameterValidator(this.isOptional());
    }
}

