/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.xml.category;

import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.xml.category.XmlCategoryElement;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLBasicElement;
import tecgraf.javautils.xml.XMLComment;
import tecgraf.javautils.xml.XMLElementInterface;

public class XmlCategoriesElement
extends XMLBasicElement {
    public XmlCategoriesElement() {
        this.setTag("categories");
    }

    public CategorySet getCategorySet() {
        return (CategorySet)this.getAppContextObject();
    }

    public void endTag(List<XMLElementInterface> childrenList) {
        ImprovedXMLListIterator iterator = new ImprovedXMLListIterator(childrenList);
        while (iterator.hasNext()) {
            XMLElementInterface nextElem = iterator.next();
            Category category = ((XmlCategoryElement)nextElem).getCategory();
            if (category == null) continue;
            this.getCategorySet().addCategory(category);
        }
    }

    private void writeAllCategoryElement(Writer writer, String ident) throws IOException {
        String newIdent = XMLBasicElement.getNextIdentation((String)ident);
        for (Category category : this.getCategorySet().getCategories()) {
            this.writeCategoryElement(writer, newIdent, category);
        }
    }

    private void writeCategoryElement(Writer writer, String ident, Category category) throws IOException {
        XmlCategoryElement xmlcategory = new XmlCategoryElement(category);
        xmlcategory.write(writer, ident);
    }

    public void write(Writer writer, String ident) throws IOException {
        this.writeStartTagln(writer, ident);
        String comment = "Especificando as categorias de algoritmos";
        XMLComment.write((Writer)writer, (String)ident, (String)comment);
        this.writeAllCategoryElement(writer, ident);
        this.writeEndTag(writer, ident);
    }
}

