/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameterListener;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;

public final class DoubleListParameter
extends ListParameter<Double> {
    public static final String TYPE = "LIST_OF_DOUBLES";
    private boolean isMaximumIncluded;
    private boolean isMinimumIncluded;
    private Double maximum;
    private Double minimum;
    private transient List<DoubleListParameterListener> listeners = new LinkedList<DoubleListParameterListener>();

    public DoubleListParameter(String name, String label, String description, List<Double> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Double maximum, boolean includeMaximum, Double minimum, boolean includeMinimum) {
        super(name, label, description, defaultValue, isOptional, isVisible, false, true, commandLinePattern);
        this.setMaximum(maximum, includeMaximum);
        this.setMinimum(minimum, includeMinimum);
    }

    public void addDoubleListParameterListener(DoubleListParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    public boolean isMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    public boolean setMaximum(Double maximum, boolean maximumIncluded) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException("O valor m\u00e1ximo n\u00e3o pode ser menor do que o valor m\u00ednimo.");
        }
        boolean maxIncluded = maximumIncluded;
        if (maximum == null) {
            if (this.maximum == null) {
                return false;
            }
            maxIncluded = false;
        } else if (maximum.equals(this.maximum)) {
            return false;
        }
        this.isMaximumIncluded = maxIncluded;
        this.maximum = maximum;
        this.updateValidator();
        for (DoubleListParameterListener listener : this.listeners) {
            listener.maximumWasChanged(this);
        }
        return true;
    }

    public boolean setMinimum(Double minimum, boolean minimumIncluded) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException("O valor m\u00ednimo n\u00e3o pode ser maior do que o valor m\u00e1ximo.");
        }
        boolean minIncluded = minimumIncluded;
        if (minimum == null) {
            if (this.minimum == null) {
                return false;
            }
            minIncluded = false;
        } else if (minimum.equals(this.minimum)) {
            return false;
        }
        this.isMinimumIncluded = minIncluded;
        this.minimum = minimum;
        this.updateValidator();
        for (DoubleListParameterListener listener : this.listeners) {
            listener.minimumWasChanged(this);
        }
        return true;
    }

    private void updateValidator() {
        ListParameterValidator listParameterValidator = (ListParameterValidator)this.getParameterValidator();
        DoubleParameterValidator validator = (DoubleParameterValidator)listParameterValidator.getItemValidator();
        validator.setMaximum(this.maximum, this.isMaximumIncluded);
        validator.setMinimum(this.minimum, this.isMinimumIncluded);
    }

    @Override
    public Double getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        try {
            double doubleValue = Double.parseDouble(itemValue);
            return new Double(doubleValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException("O valor {0} foi atribuido ao par\u00e2metro {1}, por\u00e9m ele n\u00e3o \u00e9 um valor v\u00e1lido para um n\u00famero real.", itemValue, this);
        }
    }

    protected DoubleParameterValidator createItemValidator() {
        return new DoubleParameterValidator(this.isOptional(), this.maximum, this.isMaximumIncluded, this.minimum, this.isMinimumIncluded);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<DoubleListParameterListener>();
    }
}

