/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.IElementStructure;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedElement;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class SimpleParameterParser<T extends SimpleParameter<?>>
implements ParameterFactory {
    public abstract T createSimpleParameter(XmlParser var1, ParsedSimpleParameter var2, ParameterGroup var3, SimpleAlgorithmConfigurator var4) throws ParseException;

    public T createParameter(XmlParser parser, String defaultCommandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Map<IElementAttribute<?>, Object> attributeValues = parser.extractAttributes(this.getParameterStructure());
        Map<IElementStructure<?>, List<ParsedElement>> children = parser.extractChildren(this.getParameterStructure().getChildElements());
        ParsedSimpleParameter definition = new ParsedSimpleParameter(attributeValues, children, defaultCommandLinePattern);
        T parameter = this.createSimpleParameter(parser, definition, group, configurator);
        ((SimpleParameter)parameter).setIgnoreIfDisabled(definition.isIgnoreIfDisabled());
        ((SimpleParameter)parameter).setIgnoreIfInvisible(definition.isIgnoreIfInvisible());
        return parameter;
    }

    public abstract ParameterStructure<T> getParameterStructure();

    @Override
    public final List<ParameterStructure<?>> getParameterStructures() {
        return Collections.singletonList(this.getParameterStructure());
    }
}

