/**
 * $Id$
 */

package csbase.logic;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Interface usada para notificaes de obteno de lock ou quando o lock foi
 * expirado.  passado como parmetro dos mtodos
 * ProjectServiceInterface.aquireSharedLock() e
 * ProjectServiceInterface.aquireExclusiveLock().
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface FileLockListenerInterface extends Remote {

  /**
   * Mtodo chamado quando o lock  obtido.
   * 
   * @param lockId idenficador do pedido de lock obtido
   * @throws RemoteException falha de rmi
   */
  public void fileLocked(Object lockId) throws RemoteException;

  /**
   * Mtodo chamado quando o lock  expirado por timeout.
   * 
   * @param lockId idenficador do pedido de lock expirado
   * @throws RemoteException falha de rmi
   */
  public void fileLockExpired(Object lockId) throws RemoteException;
}
