/*
 * PlatformInfo.java
 *
 * $Author: tatimf $ $Revision: 175498 $ - $Date: 2004-10-19 07:40:53 -0300
 * (Ter, 19 out 2004) $
 */
package csbase.logic;

import java.io.Serializable;

/**
 * A classe {@code PlatformInfo} contm informaes de uma plataforma de
 * execuo (Platform).
 *
 * @author Marcos Machado
 */
public class PlatformInfo implements Serializable, Cloneable {
  /**
   * Nome da plataforma. O nome de uma plataforma indica o sistema operacional e
   * verso do mesmo. Exemplo: IRIX65
   */
  public String name;

  /** Descrio da plataforma */
  public String description;

  /**
   * {@inheritDoc}
   */
  @Override
  public Object clone() {
    try {
      return super.clone();
    }
    catch (CloneNotSupportedException e) {
      return null;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (!(obj instanceof PlatformInfo)) {
      return false;
    }
    PlatformInfo info = (PlatformInfo) obj;
    return name.equals(info.name) && description.equals(info.description);
  }

  /**
   * Calcula o cdigo hash do objeto.
   *
   * @return Inteiro que representa o cdigo hash do objeto.
   */
  @Override
  public int hashCode() {
    return (name + description).hashCode();
  }

  /**
   * Cria um PlatformInfo.
   *
   * @param name .
   * @param description .
   */
  public PlatformInfo(String name, String description) {
    this.name = (name != null ? name : "");
    this.description = (description != null ? description : "");
  }
}
