/*
 * NotificationData.java
 * $Author: cassino $
 * $Revision: 116055 $  - $Date: 2011-03-04 15:15:45 -0300 (Fri, 04 Mar 2011) $
 */
package csbase.logic;


/**
 * Representa o contedo da mensagem de notificao.
 */
public class ServerNotification extends Notification {

  /** Atributo de estado (on)/(off) */
  private boolean state;

  /**
   * Consulta ao modo start-up.
   *
   * @return <code>true</code> se o servidor entrou no ar,  <code>false</code>
   *         caao contrrio.
   */
  public boolean getState() {
    return state;
  }

  /**
   * Definio da volatilidade da notificao.
   * @return flag indicativo.
   */
  public boolean isVolatile() {
    return false;
  }

  /**
   * String para auditagem.
   *
   * @return uma string
   */
  public String toString() {
    if (state) {
      return "Server/START";
    }
    else {
      return "Server/SHUTDOWN";
    }
  }

  /**
   * Constri o evento de incio do SSI.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param state estado on/off.
   */
  public ServerNotification(String sender, boolean state) {
    super(sender);
    this.state = state;
  }
}
