/*
 * $Id$
 */
package csbase.logic.algorithms;

import java.io.Serializable;

/**
 * Operaes possveis para uma importao de um Pacote de Algoritmo.
 */
public enum PAImportOperation implements Serializable {
  /** Importao dos algoritmos com substituio dos mesmos no repositrio */
  REPLACE_ALGORITHMS,
  /** Importao dos algoritmos com merge dos mesmos no repositrio */
  MERGE_ALGORITHMS,
  /**
   * Importao dos algoritmos com conservao dos que j existirem no
   * repositrio
   */
  KEEP_ALGORITHMS,
  /**
   * Importao dos algoritmos com merge dos algoritmos e substituio de
   * verses iguais no repositrio
   */
  REPLACE_VERSIONS,
  /**
   * Importao dos algoritmos com merge dos algoritmos e conservao de verses
   * iguais no repositrio
   */
  KEEP_VERSIONS,
  /**
   * Importao dos algoritmos com merge dos algoritmos e substituio de
   * categorias iguais no repositrio
   */
  REPLACE_CATEGORIES,
  /**
   * Importao dos algoritmos com merge dos algoritmos e conservao de
   * categorias iguais no repositrio
   */
  KEEP_CATEGORIES,
  /**
   * Importao dos algoritmos com merge dos algoritmos e juno de categorias
   * no repositrio
   */
  MERGE_CATEGORIES,
}
