package csbase.logic.algorithms.parameters;

import java.util.List;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;

/**
 * Mtodo que determina o maior valor de uma tabela.
 */
public final class TableMaxExpressionFunction extends TableExpressionFunction {

  /**
   * Construtor.
   */
  public TableMaxExpressionFunction() {
    super("table_max", new Class[] {});
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Object doOperation(List<Object> values, Object... arguments)
    throws ExpressionFunctionExecutionException {
    if (values == null) {
      throw new ExpressionFunctionExecutionException("A tabela est vazia.");
    }
    double maxValue = Double.MIN_VALUE;
    for (Object value : values) {
      double doubleValue = Double.parseDouble(value.toString());
      if (doubleValue > maxValue) {
        maxValue = doubleValue;
      }
    }
    return maxValue;
  }
}
