package csbase.logic.algorithms.parsers;

import java.util.HashMap;
import java.util.Map;

import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.columns.BooleanColumnFactory;
import csbase.logic.algorithms.parsers.columns.DoubleColumnFactory;
import csbase.logic.algorithms.parsers.columns.EnumerationColumnFactory;
import csbase.logic.algorithms.parsers.columns.IntegerColumnFactory;
import csbase.logic.algorithms.parsers.columns.TableColumnFactory;
import csbase.logic.algorithms.parsers.columns.TextColumnFactory;

/**
 * Analisador padro de {@link TableParameter}.
 */
public class DefaultTableParameterFactory extends
  AbstractTableParameterFactory {
  /**
   * Mapa que associa as fbricas de colunas ao nome do elemento.
   */
  private Map<String, TableColumnFactory> factoriesByElementName;

  /**
   * Cria o analisador.
   */
  public DefaultTableParameterFactory() {
    factoriesByElementName = new HashMap<String, TableColumnFactory>();
    addFactory(new BooleanColumnFactory());
    addFactory(new DoubleColumnFactory());
    addFactory(new EnumerationColumnFactory());
    addFactory(new IntegerColumnFactory());
    addFactory(new TextColumnFactory());
  }

  /**
   * Registra uma fbrica de colunas na fbrica de tabelas.
   *
   * @param factory A fbrica (No aceita {@code null}).
   */
  protected final void addFactory(TableColumnFactory factory) {
    factoriesByElementName.put(factory.getElementName(), factory);
  }

  /**
   * Cria a fbrica de colunas.
   *
   * @param elementName O nome do elemento que est sendo processado.
   *
   * @return A fbrica ou {@code null} caso no haja fbrica cadastrada para
   *         este elemento.
   */
  @Override
  protected final TableColumnFactory createFactory(String elementName) {
    return factoriesByElementName.get(elementName);
  }
}
