package csbase.logic.server;

/**
 * Representa um evento de adio de {@link ServerInfo informaes de um
 * servidor} no repositrio.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ServerInfoAddEvent extends ServerInfoEvent {
  /** {@link ServerInfo} adicionado. */
  private ServerInfo serverInfo;

  /**
   * Cria um evento de adio de um {@link ServerInfo}.
   *
   * @param serverInfo O {@link ServerInfo} que foi adicionado.
   */
  public ServerInfoAddEvent(ServerInfo serverInfo) {
    super(ServerInfoEventType.ADD);
    this.serverInfo = serverInfo;
  }

  /**
   * Obtm o {@link ServerInfo} adicionado.
   *
   * @return O {@link ServerInfo} adicionado.
   */
  public ServerInfo getServerInfo() {
    return this.serverInfo;
  }
}
