/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.conditions;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.exception.algorithms.FormulaEvaluationException;
import csbase.logic.algorithms.parameters.Expression;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;

public final class GenericCondition
implements Condition {
    private final Expression expression;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericCondition other = (GenericCondition)obj;
        return this.expression.equals(other.expression);
    }

    @Override
    public boolean evaluate(SimpleAlgorithmConfigurator configurator) {
        try {
            return this.expression.evaluate(configurator);
        }
        catch (FormulaEvaluationException e) {
            for (Throwable cause = e; cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                cause.printStackTrace();
            }
            return false;
        }
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public GenericCondition(String expressionText) throws FormulaCreationException, ParseException {
        this.expression = new Expression(expressionText);
    }
}

