/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import java.text.MessageFormat;

public final class ChangeMinimumForDoublesTrigger
extends Trigger<SimpleParameter<?>> {
    private boolean isMinimumIncluded;
    private Double minimum;

    public ChangeMinimumForDoublesTrigger(DoubleParameter parameter, Condition condition, Double minimum, boolean isMinimumIncluded) {
        super(parameter, condition);
        this.isMinimumIncluded = isMinimumIncluded;
        this.minimum = minimum;
    }

    public ChangeMinimumForDoublesTrigger(DoubleListParameter parameter, Condition condition, Double minimum, boolean isMinimumIncluded) {
        super(parameter, condition);
        this.isMinimumIncluded = isMinimumIncluded;
        this.minimum = minimum;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChangeMinimumForDoublesTrigger trigger = (ChangeMinimumForDoublesTrigger)obj;
        if (this.isMinimumIncluded != trigger.isMinimumIncluded) {
            return false;
        }
        if (this.minimum == null && trigger.minimum == null) {
            return true;
        }
        return this.minimum != null && this.minimum.equals(trigger.minimum);
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public boolean isMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    @Override
    protected void doAction() {
        SimpleParameter parameter = (SimpleParameter)this.getParameter();
        if (parameter instanceof DoubleListParameter) {
            DoubleListParameter doubleListParameter = (DoubleListParameter)parameter;
            doubleListParameter.setMinimum(this.getMinimum(), this.isMinimumIncluded());
        } else if (parameter instanceof DoubleParameter) {
            DoubleParameter doubleParameter = (DoubleParameter)parameter;
            doubleParameter.setMinimum(this.getMinimum(), this.isMinimumIncluded());
        } else {
            throw new IllegalStateException(MessageFormat.format("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2}.", parameter.getLabel(), "real", "lista_de_reais"));
        }
    }

    @Override
    protected void undoAction() {
    }
}

