package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Trigger de troca de label.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ChangeLabelTrigger extends Trigger<SimpleParameter<?>> {

  /**
   * Label default.
   */
  private String defaultLabel;
  /**
   * Novo label
   */
  private String newLabel;

  /**
   * Construtor
   * 
   * @param parameter parmetro
   * @param condition condio
   * @param newLabel novo label
   */
  public ChangeLabelTrigger(SimpleParameter<?> parameter, Condition condition,
    String newLabel) {
    super(parameter, condition);
    defaultLabel = parameter.getLabel();
    setNewLabel(newLabel);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setLabel(newLabel);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setLabel(defaultLabel);
  }

  /**
   * Ajuste de novo label.
   * 
   * @param newLabel novo label
   */
  private void setNewLabel(String newLabel) {
    if (newLabel == null) {
      throw new IllegalArgumentException("O parmetro newLabel est nulo.");
    }
    this.newLabel = newLabel;
  }
}
