package csbase.logic.algorithms.parsers;

import java.util.ArrayList;
import java.util.List;

import csbase.logic.algorithms.parameters.OutputURLParameter;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;

/**
 * Fbrica de parmetros do tipo URL de sada.
 *
 * @author Tecgraf
 */
public class OutputURLParameterFactory extends URLParameterFactory {

  /**
   * Parser do parmetro mltiplo.
   */
  private final OutputURLListParameterParser outputURLListParameterParser;

  /**
   * Parser do parmetro simples.
   */
  private final OutputURLParameterParser outputURLParameterParser;

  /**
   * Construtor.
   */
  public OutputURLParameterFactory() {
    outputURLParameterParser = new OutputURLParameterParser();
    outputURLListParameterParser = new OutputURLListParameterParser();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected AbstractURLParameterParser<OutputURLParameter> createSimpleURLParser() {
    return outputURLParameterParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected OutputURLListParameterParser createURLListParser() {
    return outputURLListParameterParser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<ParameterStructure<?>> getParameterStructures() {
    List<ParameterStructure<?>> types = new ArrayList<>();
    types.add(getSimpleStructure());
    types.add(getMultipleStructure());
    return types;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public BooleanAttribute getAttribute() {
    return new BooleanAttribute(
      URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_ATTRIBUTE,
      URL_PARAMETER_ELEMENT_MULTIPLE_SELECTION_DEFAULT_VALUE);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<?> getParameterStructure(boolean value) {
    if (value) {
      return getMultipleStructure();
    }
    return getSimpleStructure();
  }

  /**
   * Obtm a estrutura do parmetro simples.
   * 
   * @return estrutura do parmetro simples.
   */
  private ParameterStructure<?> getSimpleStructure() {
    ParameterStructure<?> structure = outputURLParameterParser
      .getParameterStructure();
    structure.addAttribute(getAttribute());
    return structure;
  }

  /**
   * Obtm a estrutura do parmetro mltiplo.
   * 
   * @return estrutura do parmetro mltiplo.
   */
  private ParameterStructure<?> getMultipleStructure() {
    ParameterStructure<?> structure = outputURLListParameterParser
      .getParameterStructure();
    structure.addAttribute(getAttribute());
    return structure;
  }
}
