package csbase.logic.algorithms.parsers.elements.attributes;

/**
 * Atributo do tipo enumerao.
 *
 * @param <E> a classe da enumerao.
 */
public class EnumerationAttribute <E extends Enum<E>> extends
  AbstractElementAttribute<E> {

  /**
   * Conversor de enumerao para string.
   */
  private final StringToValueConverter<E> converter;

  /**
   * Construtor.
   *
   * @param name o nome do atributo.
   * @param type o tipo da enumerao.
   * @param isOptional indicativo de atributo opcional.
   * @param defaultValue valor padro.
   * @param defaultValueAtribute atributo com valor padro.
   * @param converter conversor dos valores de enumerao para string.
   */
  EnumerationAttribute(String name, Class<E> type, boolean isOptional,
    E defaultValue, EnumerationAttribute<E> defaultValueAtribute,
    StringToValueConverter<E> converter) {
    super(name, type, isOptional, defaultValue, defaultValueAtribute);
    this.converter = converter;
  }
  /**
   * Construtor para atributos opcionais.
   *
   * @param name o nome do atributo.
   * @param type o tipo da enumerao.
   * @param defaultValue valor padro.
   * @param defaultValueAtribute atributo com valor padro.
   * @param converter conversor dos valores de enumerao para string.
   */
  public EnumerationAttribute(String name, Class<E> type, E defaultValue,
    EnumerationAttribute<E> defaultValueAtribute,
    StringToValueConverter<E> converter) {
    this(name, type, true, defaultValue, defaultValueAtribute, converter);
  }

  /**
   * Construtor.
   *
   * @param name o nome do atributo.
   * @param type o tipo do atributo.
   * @param converter conversor dos valores de enumerao para string.
   */
  public EnumerationAttribute(String name, Class<E> type,
    StringToValueConverter<E> converter) {
    this(name, type, false, null, null, converter);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public StringToValueConverter<E> getValueConverter() {
    return converter;
  }

}
