/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ServerMonitorListener;
import csbase.logic.ServerURI;
import csbase.remote.ServerEntryPoint;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ServerMonitor {
    private String clientHost;
    private ServerEntryPoint server;
    private final long OK_SLEEP_TIME = 60000L;
    private final long NOK_SLEEP_TIME = 10000L;
    private final ServerURI serverURI;
    private AtomicBoolean serverReachable = new AtomicBoolean(false);
    private AtomicBoolean mustContinue = new AtomicBoolean(false);
    private List<ServerMonitorListener> listeners;
    private int maxRetries;
    private Thread monitor;
    private Thread serverLookupThread;
    private boolean verbose = true;

    public ServerMonitor(ServerURI serverURI) {
        this(serverURI, 0);
    }

    public ServerMonitor(ServerURI serverURI, int maxRetries) {
        this(serverURI, maxRetries, true);
    }

    public ServerMonitor(ServerURI serverURI, int maxRetries, boolean verbose) {
        this.verbose = verbose;
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries deve ser > 0");
        }
        this.maxRetries = maxRetries;
        this.serverURI = serverURI;
        this.listeners = new ArrayList<ServerMonitorListener>();
        this.createLookupthread();
    }

    private final void createMonitorThread() {
        this.monitor = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int retries = 0;
                while (ServerMonitor.this.mustContinue.get()) {
                    if (ServerMonitor.this.tryReaching()) {
                        retries = 0;
                    } else if (ServerMonitor.this.maxRetries > 0 && ++retries >= ServerMonitor.this.maxRetries && !ServerMonitor.this.isReachable()) {
                        ServerMonitor.this.logWarning("Monitora\u00e7\u00e3o de " + ServerMonitor.this.serverURI + " interrompida por atingir n\u00famero m\u00e1ximo de tentativas (MAXRETRIES = " + ServerMonitor.this.maxRetries + ")");
                        ServerMonitor.this.stopMonitoring();
                    }
                    try {
                        ServerMonitor serverMonitor = ServerMonitor.this;
                        synchronized (serverMonitor) {
                            ServerMonitor.this.wait(ServerMonitor.this.isReachable() ? 60000L : 10000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, "serverMonitorThread-" + this.getURI());
        try {
            this.monitor.setDaemon(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected void logError(String msg, Throwable t) {
        System.err.println(msg);
        System.err.println(t);
    }

    protected void logWarning(String msg) {
        System.out.println(msg);
    }

    protected void logInfo(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    private void loadServerEntryPoint() {
        String serverPath = "rmi://" + this.getURI().getHostAndPort() + "/" + "Server";
        try {
            this.logInfo("Contactando servidor " + this.serverURI);
            this.server = null;
            this.server = (ServerEntryPoint)((Object)Naming.lookup(serverPath));
            this.serverReachable.set(true);
            this.logInfo("Servidor " + this.serverURI + " contactado.");
        }
        catch (UnmarshalException e) {
            this.logError("Vers\u00e3o do cliente incompat\u00edvel com o servidor.", e);
        }
        catch (RemoteException e) {
            this.logInfo("Servidor " + this.serverURI + " fora do ar.");
        }
        catch (NotBoundException e) {
            this.logError("O ServerEntryPoint n\u00e3o foi exportado pelo servidor " + this.serverURI, e);
        }
        catch (MalformedURLException e) {
            this.logError(MessageFormat.format("A URL para acesso ao ServerEntryPoint est\u00e1 inv\u00e1lida: {0}.", serverPath), e);
        }
    }

    public final boolean lookup() {
        try {
            if (!this.isReachable() && !this.getServerLookupThread().isAlive()) {
                this.createLookupthread().start();
            }
            this.getServerLookupThread().join();
            if (this.server == null) {
                this.serverReachable.set(false);
                return false;
            }
            this.serverReachable.set(true);
        }
        catch (InterruptedException e1) {
            this.logWarning("Thread de lookup interrompida.");
        }
        return true;
    }

    private boolean hasClientIPChanged() {
        try {
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            String string = this.clientHost = this.clientHost == null ? hostAddress : this.clientHost;
            if (!this.clientHost.equals(hostAddress)) {
                this.logInfo("Client IP has changed.");
                this.logInfo("clientHost " + this.clientHost);
                this.logInfo("newClientHost " + hostAddress);
                this.clientHost = hostAddress;
                this.notifyClientIPChanged();
                return true;
            }
        }
        catch (UnknownHostException e) {
            String msg = String.format("Erro de Host desconhecido:\n %s", e.getMessage());
            this.logError(msg, e);
        }
        return false;
    }

    protected boolean tryReaching() {
        if (!this.ping() || this.hasClientIPChanged()) {
            if (this.serverReachable.compareAndSet(true, false)) {
                this.notifyServerUnreachable();
            }
            if (this.lookup()) {
                this.notifyServerReachable();
                return true;
            }
            return false;
        }
        return true;
    }

    public final synchronized void invalidate() {
        this.notifyAll();
    }

    public final boolean ping() {
        if (this.server == null || !this.isReachable()) {
            return false;
        }
        try {
            this.server.ping();
            return true;
        }
        catch (RemoteException e) {
            this.server = null;
            this.invalidate();
            return false;
        }
    }

    public final boolean isReachable() {
        return this.serverReachable.get();
    }

    public final void startMonitoring() {
        if (this.mustContinue.get()) {
            return;
        }
        if (this.monitor == null || !this.monitor.isAlive()) {
            this.mustContinue.set(true);
            this.createMonitorThread();
            this.monitor.start();
        }
    }

    public final void stopMonitoring() {
        this.mustContinue.set(false);
        this.serverReachable.set(false);
        this.invalidate();
    }

    public final boolean isMonitoring() {
        return this.mustContinue.get();
    }

    private final void notifyServerUnreachable() {
        for (ServerMonitorListener listener : this.listeners) {
            listener.notifyServerUnreachable(this.serverURI);
        }
    }

    private final void notifyServerReachable() {
        for (ServerMonitorListener listener : this.listeners) {
            listener.notifyServerReachable(this.serverURI);
        }
    }

    private final void notifyClientIPChanged() {
        for (ServerMonitorListener listener : this.listeners) {
            listener.notifyClientIPChanged(this.serverURI);
        }
    }

    public final void addListener(ServerMonitorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public final void deleteListener(ServerMonitorListener listener) {
        this.listeners.remove(listener);
    }

    public final ServerURI getURI() {
        return this.serverURI;
    }

    public final Thread getServerLookupThread() {
        return this.serverLookupThread;
    }

    public final ServerEntryPoint getServer() {
        if (!this.isReachable()) {
            return null;
        }
        return this.server;
    }

    private Thread createLookupthread() {
        this.serverLookupThread = new Thread(){

            @Override
            public void run() {
                ServerMonitor.this.loadServerEntryPoint();
            }
        };
        return this.serverLookupThread;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

