/*
 * CommandFailedNotificationData.java
 * 
 * $Author$ $Date$
 * $Revision$
 */
package csbase.logic;

/**
 * Classe que representa os dados de mensagem de falha na inicializao de um
 * comando em um SGA. Essa notificao indica que a execuo nem pde ser
 * iniciada, por uma falha inesperada.
 */
public class CommandFailedNotification extends
  DefaultCommandFinishedNotification {

  /**
   * Constri o evento de falha de comando sem dados de tempo.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param commandId identificador do comando.
   * @param cmdDesc descrio do comando.
   * @param tip Dica para auxiliar a identificao do algoritmo do comando.
   * @param startTime Hora de incio
   * @param execHost Servidor de execuo.
   * @param projectId identificador do projeto.
   * @param finalizationInfo Informaes sobre a finalizao do comando.
   */
  public CommandFailedNotification(String sender, Object commandId,
    String cmdDesc, String tip, long startTime, String execHost,
    Object projectId, CommandFinalizationInfo finalizationInfo) {
    super(sender, commandId, cmdDesc, tip, startTime, execHost, projectId,
      finalizationInfo);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected String getStatusString() {
    return "FAILED";
  }
}
