/*
 * $Id$
 */
package csbase.remote;

import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;

import csbase.exception.InvalidRequestException;
import csbase.logic.diskusageservice.DiskOccupation;

/**
 * Interface remota para acesso ao Servio de notificao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface DiskUsageServiceInterface extends ServiceInterface {

  /**
   * Identificador de rea de projetos.
   */
  public static final String DIR_PROJECT_ID = "project";

  /**
   * Identificador de rea de algoritmos.
   */
  public static final String DIR_ALGORITHM_ID = "algorithm";

  /**
   * Identificador de rea do servidor.
   */
  public static final String DIR_SERVER_ID = "server";

  /**
   * Nome do servio para o <code>ServiceManager</code>
   */
  public static final String SERVICE_NAME = "DiskUsageService";

  /**
   * Consulta a lista de (usurios/espao ocupado) da rea de projetos
   * 
   * @return a hash.
   * @throws RemoteException se houver falha de comunicao.
   */
  public Hashtable<Object, Double> getUsersList() throws RemoteException;

  /**
   * Consulta o espao (em Mb) ocupado por um usurio.
   * 
   * @param userId id do usurio
   * @return o espao ocupado.
   * @throws RemoteException se houver falha de comunicao.
   */
  public double getUsedSpaceForUserMb(Object userId) throws RemoteException;

  /**
   * Consulta o espao (em Mb) ocupado por um projeto.
   * 
   * @param ownerId id do owner
   * @param projName id do projeto
   * @return o espao ocupado.
   * @throws RemoteException se houver falha de comunicao.
   * @throws InvalidRequestException caso algum parmetro seja nulo
   */
  public double getUsedSpaceForProjectMb(final Object ownerId,
    final String projName) throws RemoteException;

  /**
   * Consulta o espao da rea de um projeto
   * 
   * @param ownerId id do owner
   * @param projName id do projeto
   * @return espao
   * @throws RemoteException falha de rmi
   */
  public DiskOccupation getSingleProjectOccupation(final Object ownerId,
    final String projName) throws RemoteException;

  /**
   * Consulta o espao da rea de algoritmos
   * 
   * @return espao
   * @throws RemoteException falha de rmi
   */
  public DiskOccupation getAlgorithmOccupation() throws RemoteException;

  /**
   * Consulta o espao da rea do servidor.
   * 
   * @return espao
   * @throws RemoteException falha de rmi
   */
  public DiskOccupation getServerOccupation() throws RemoteException;

  /**
   * Consulta o espao da rea de projetos.
   * 
   * @return espao
   * @throws RemoteException falha de rmi
   */
  public DiskOccupation getProjectOccupation() throws RemoteException;

  /**
   * Consulta a lista de ids existentes (configurados) pelo administrador
   * 
   * @return lista de ids
   * @throws RemoteException falha de rmi
   */
  public List<String> getAllAreasIds() throws RemoteException;

  /**
   * Consulta a ocupao de uma rea configurada pelo administrador (id).
   * 
   * @param id identificador da rea (previamente configurada)
   * @return a ocupao (podendo ser {@code null} se o id no existir).
   * @throws RemoteException falha de rmi
   */
  public DiskOccupation getAreaOccupation(String id) throws RemoteException;
}
