/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BasicColumn;
import csbase.logic.algorithms.parameters.validators.DoubleParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;

public final class DoubleColumn
extends BasicColumn<Double> {
    private boolean isMaximumIncluded;
    private boolean isMinimumIncluded;
    private Double maximum;
    private Double minimum;

    public DoubleColumn(String id, String label, Double defaultValue, boolean isOptional, boolean isEditable, Double maximum, boolean isMaximumIncluded, Double minimum, boolean isMinimumIncluded) {
        super(id, label, defaultValue, isOptional, isEditable);
        this.setMaximum(maximum, isMaximumIncluded);
        this.setMinimum(minimum, isMinimumIncluded);
    }

    @Override
    public Double getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        try {
            double doubleValue = Double.parseDouble(itemValue);
            return new Double(doubleValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException("O valor {0} foi atribuido \u00e0 coluna {1}, por\u00e9m ele n\u00e3o \u00e9 um valor v\u00e1lido para um n\u00famero real.", itemValue, this);
        }
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public boolean isMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    public boolean isMinimumIncluded() {
        return this.isMinimumIncluded;
    }

    @Override
    public SimpleParameterValidator<Double> getValidator() {
        return new DoubleParameterValidator(this.isOptional(), this.getMaximum(), this.isMaximumIncluded(), this.getMinimum(), this.isMinimumIncluded());
    }

    private void setMaximum(Double maximum, boolean isMaximumIncluded) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException("O valor m\u00e1ximo n\u00e3o pode ser menor do que o valor m\u00ednimo.");
        }
        this.isMaximumIncluded = maximum == null ? false : isMaximumIncluded;
        this.maximum = maximum;
    }

    private void setMinimum(Double minimum, boolean isMinimumIncluded) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException("O valor m\u00ednimo n\u00e3o pode ser maior do que o valor m\u00e1ximo.");
        }
        this.isMinimumIncluded = minimum == null ? false : isMinimumIncluded;
        this.minimum = minimum;
    }
}

