/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.IntegerStructureAttributes;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;

public class IntegerParameterFactory
extends SimpleParameterParser<IntegerParameter>
implements IntegerStructureAttributes {
    public static final String INTEGER_PARAMETER_ELEMENT = "inteiro";

    @Override
    public IntegerParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Integer maximum = (Integer)definition.getAttributeValue("maximo");
        Integer minimum = (Integer)definition.getAttributeValue("minimo");
        IntegerAttribute attribute = (IntegerAttribute)definition.getAttribute("padrao");
        attribute.setMaximumValue(maximum);
        attribute.setMinimumValue(minimum);
        Integer defaultValue = (Integer)definition.getAttributeValue("padrao");
        definition.checkValues();
        IntegerParameter parameter = new IntegerParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), maximum, minimum);
        return parameter;
    }

    @Override
    public ParameterStructure<IntegerParameter> getParameterStructure() {
        ParameterStructure<IntegerParameter> integerStructure = this.getIntegerStructure(INTEGER_PARAMETER_ELEMENT, IntegerParameter.class);
        integerStructure.addAttribute(new IntegerAttribute("padrao", null));
        return integerStructure;
    }
}

