/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows;

import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.parameters.FileURLValue;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public final class Flow
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private Set<FlowLink> links;
    private Set<FlowNode> nodes;

    public Flow(String name, String description, Set<FlowNode> nodes, Set<FlowLink> links) {
        this.name = name;
        this.description = description;
        this.setLinks(links);
        this.setNodes(nodes);
    }

    private String formatFilePathForNode(String file, int nodeId) {
        String formattedFilename;
        String extension = FileUtils.getFileExtension((String)file);
        String filePath = FileUtils.getFilePath((String)file);
        if (extension != null) {
            String fileWithExtension = FileUtils.getFileName((String)file);
            String filename = fileWithExtension.substring(0, fileWithExtension.lastIndexOf(extension) - 1);
            formattedFilename = String.format("%s/%s%s.%s", filePath, filename, nodeId, extension);
        } else {
            formattedFilename = String.format("%s%s", file, nodeId);
        }
        return formattedFilename;
    }

    public void setStandardOutputFile(FileURLValue standardOutputFile) {
        String stdOutPath = standardOutputFile.getPath();
        String type = standardOutputFile.getType();
        for (FlowNode node : this.nodes) {
            int nodeId = node.getId();
            String nodeStdOutPath = this.formatFilePathForNode(stdOutPath, nodeId);
            FileURLValue nodeStdOut = new FileURLValue(nodeStdOutPath, type);
            node.setStandardOutputFile(nodeStdOut);
        }
    }

    public Set<FileURLValue> getStandardOutputFiles() {
        HashSet<FileURLValue> stdouts = new HashSet<FileURLValue>();
        for (FlowNode node : this.nodes) {
            if (node.isBypassed() || null == node.getStandardOutputFile()) continue;
            stdouts.add(node.getStandardOutputFile());
        }
        return Collections.unmodifiableSet(stdouts);
    }

    public Flow clone() {
        try {
            Flow clone = (Flow)super.clone();
            clone.name = this.name;
            clone.description = this.description;
            clone.links = new HashSet<FlowLink>();
            for (FlowLink flowLink : this.links) {
                clone.links.add(flowLink.clone());
            }
            clone.nodes = new HashSet<FlowNode>();
            for (FlowNode flowNode : this.nodes) {
                clone.nodes.add(flowNode.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public Set<FlowLink> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public String getName() {
        return this.name;
    }

    public FlowNode getNode(int nodeId) {
        for (FlowNode node : this.nodes) {
            if (node.getId() != nodeId) continue;
            return node;
        }
        return null;
    }

    public Set<FlowNode> getNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    private void setLinks(Set<FlowLink> links) {
        if (links == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "links"));
        }
        this.links = new HashSet<FlowLink>(links);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "name"));
        }
        this.name = name;
    }

    private void setNodes(Set<FlowNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "nodes"));
        }
        this.nodes = new HashSet<FlowNode>(nodes);
    }

    public void setExitCodeLogFile(FileURLValue exitCodeLogFile) {
        String exitCodeFilePath = exitCodeLogFile.getPath();
        String type = exitCodeLogFile.getType();
        for (FlowNode node : this.nodes) {
            int nodeId = node.getId();
            String nodeExitCodeFilePath = this.formatFilePathForNode(exitCodeFilePath, nodeId);
            FileURLValue nodeExitCodeFile = new FileURLValue(nodeExitCodeFilePath, type);
            if (!node.hasExitCode()) continue;
            node.setExitCodeLogFile(nodeExitCodeFile);
        }
    }

    public void setWarningsFile(FileURLValue warningsFile) {
        String warningsFilePath = warningsFile.getPath();
        String type = warningsFile.getType();
        for (FlowNode node : this.nodes) {
            int nodeId = node.getId();
            String nodeWarningsFilePath = this.formatFilePathForNode(warningsFilePath, nodeId);
            FileURLValue nodeWarningsFile = new FileURLValue(nodeWarningsFilePath, type);
            node.setWarningsFile(nodeWarningsFile);
        }
    }

    public Set<FileURLValue> getWarningsFiles() {
        HashSet<FileURLValue> files = new HashSet<FileURLValue>();
        for (FlowNode node : this.nodes) {
            if (node.isBypassed() || null == node.getWarningsFile()) continue;
            files.add(node.getWarningsFile());
        }
        return Collections.unmodifiableSet(files);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<FileURLValue> getExitCodeLogFiles() {
        HashSet<FileURLValue> exitCodeFiles = new HashSet<FileURLValue>();
        for (FlowNode node : this.nodes) {
            if (!node.hasExitCode() || node.getExitCodeLogFile() == null) continue;
            exitCodeFiles.add(node.getExitCodeLogFile());
        }
        return Collections.unmodifiableSet(exitCodeFiles);
    }

    public boolean hasExitCode() {
        for (FlowNode node : this.nodes) {
            if (!node.hasExitCode()) continue;
            return true;
        }
        return false;
    }
}

