/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.AttributesPermission;
import csbase.logic.User;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LoginAsPermission
extends AttributesPermission {
    public LoginAsPermission() {
    }

    public LoginAsPermission(String name, String description, String[] attributes) {
        super(name, description, attributes);
    }

    public boolean canLoginAs(String realUserLogin, String newUserLogin) {
        boolean ret = false;
        block0: for (String attr : this.attributes) {
            String realUserList;
            String corporateUser = attr.substring(0, attr.indexOf("="));
            if (corporateUser == null || !corporateUser.equals(newUserLogin) || (realUserList = attr.substring(attr.indexOf("=") + 1)) == null) continue;
            StringTokenizer st = new StringTokenizer(realUserList, ",");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(realUserLogin)) continue;
                ret = true;
                continue block0;
            }
        }
        return ret;
    }

    public List<String> getAllowedLogins(String realUserLogin) {
        ArrayList<String> ret = new ArrayList<String>();
        block0: for (String attr : this.attributes) {
            String realUserList;
            String corporateUser = attr.substring(0, attr.indexOf("="));
            if (corporateUser == null || (realUserList = attr.substring(attr.indexOf("=") + 1)) == null) continue;
            StringTokenizer st = new StringTokenizer(realUserList, ",");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(realUserLogin)) continue;
                ret.add(corporateUser);
                continue block0;
            }
        }
        return ret;
    }

    @Override
    public boolean validate() {
        boolean ret = true;
        if (this.attributes == null || this.attributes.length == 0) {
            return false;
        }
        block0: for (String attr : this.attributes) {
            if (attr.indexOf("=") == -1) {
                ret = false;
                break;
            }
            String corporateUser = attr.substring(0, attr.indexOf("="));
            if (corporateUser == null) continue;
            if (this.getUserByLogin(corporateUser.trim()) == null) {
                ret = false;
                break;
            }
            String realUserList = attr.substring(attr.indexOf("=") + 1);
            if (realUserList == null) continue;
            StringTokenizer st = new StringTokenizer(realUserList, ",");
            while (st.hasMoreTokens()) {
                if (this.getUserByLogin(st.nextToken().trim()) != null) continue;
                ret = false;
                continue block0;
            }
        }
        return ret;
    }

    private User getUserByLogin(String login) {
        User ret = null;
        try {
            ret = User.getUserByLogin(login);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

