/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.ListParameterParser;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.ListParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.parsers.exception.AutomatonException;

public abstract class ListParameter<E>
extends SimpleParameter<List<E>> {
    protected boolean mustSort;
    protected boolean acceptDuplicates;

    protected ListParameter(String name, String label, String description, List<E> defaultValue, boolean isOptional, boolean isVisible, boolean mustSort, boolean acceptDuplicates, String commandLinePattern) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        this.mustSort = mustSort;
        this.acceptDuplicates = acceptDuplicates;
    }

    public final boolean addElement(E element) {
        if (element == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "element"));
        }
        List values = (List)this.getValue();
        LinkedList<E> newValues = values == null ? new LinkedList<E>() : new LinkedList(values);
        if (!this.acceptDuplicates && newValues.contains(element)) {
            return false;
        }
        newValues.add(element);
        if (this.mustSort) {
            Collections.sort(newValues, this.getItemComparator());
        }
        return this.setValue(newValues);
    }

    @Override
    public Object getExpressionValue() {
        return this.getName();
    }

    @Override
    public String getValueAsText() {
        List values = (List)this.getValue();
        if (values == null || values.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        Iterator valueIterator = values.iterator();
        String separator = "";
        while (valueIterator.hasNext()) {
            buffer.append(separator);
            buffer.append(this.getItemValueAsText(valueIterator.next()));
            separator = Character.toString(',');
        }
        buffer.append('}');
        return buffer.toString();
    }

    public final boolean removeElementObj(E element) {
        if (element == null) {
            return false;
        }
        List values = (List)this.getValue();
        int index = values.indexOf(element);
        if (index < 0) {
            return false;
        }
        return this.removeElement(index);
    }

    public final boolean removeElement(int index) {
        List values = (List)this.getValue();
        if (values == null) {
            return false;
        }
        if (index < 0 || index >= values.size()) {
            return false;
        }
        if (values.size() == 1) {
            this.setValue(null);
        } else {
            LinkedList newValues = new LinkedList(values);
            newValues.remove(index);
            this.setValue(newValues);
        }
        return true;
    }

    public final boolean setElement(int index, E newElement) {
        List values = (List)this.getValue();
        if (values == null) {
            throw new UnsupportedOperationException(LNG.get((String)"csbase.logic.algorithms.parameters.EmptyElementList"));
        }
        if (index < 0 || index >= values.size()) {
            String message = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.IndexOutOfBounds"), new Integer(index), new Integer(values.size()));
            throw new IllegalArgumentException(message);
        }
        Object oldElement = values.get(index);
        if (oldElement.equals(newElement)) {
            return false;
        }
        LinkedList<E> newValues = new LinkedList<E>(values);
        newValues.set(index, newElement);
        this.setValue(newValues);
        return true;
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue != null) {
            List<String> textValues;
            ListParameterParser parser = new ListParameterParser();
            LinkedList<E> values = new LinkedList<E>();
            try {
                textValues = parser.parseText(parameterValue);
            }
            catch (AutomatonException e) {
                throw new ParseException(e, LNG.get((String)"csbase.logic.algorithms.parameters.InvalidToList"), parameterValue, this);
            }
            for (String textValue : textValues) {
                values.add(this.getItemValueFromText(textValue));
            }
            this.setValue(values);
        } else {
            this.setValue(null);
        }
    }

    public abstract E getItemValueFromText(String var1) throws ParseException;

    protected String getItemValueAsText(E element) {
        if (element == null) {
            return null;
        }
        return element.toString();
    }

    @Override
    protected String getCommandValue(CommandLineContext context) {
        List values = (List)this.getValue();
        if (values == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        for (Object value : values) {
            buffer.append(separator);
            buffer.append(this.getCommandItemValue(context, value));
            separator = ",";
        }
        return buffer.toString();
    }

    protected String getCommandItemValue(CommandLineContext context, E itemValue) {
        return itemValue.toString();
    }

    @Override
    public ListParameterValidator<E> createParameterValidator() {
        return new ListParameterValidator<E>(this.createItemValidator());
    }

    protected abstract SimpleParameterValidator<E> createItemValidator();

    public boolean mustSort() {
        return this.mustSort;
    }

    protected Comparator<E> getItemComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                return ListParameter.this.getItemValueAsText(o1).compareTo(ListParameter.this.getItemValueAsText(o2));
            }
        };
    }

    @Override
    public String getValueAsJSON() {
        List values = (List)this.getValue();
        if (values == null || values.isEmpty()) {
            return "";
        }
        return this.objectToJSON(values);
    }
}

