/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.IntegerParameterListener;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class IntegerParameter
extends SimpleParameter<Integer> {
    public static final String TYPE = "INTEGER";
    public static final int ERROR_VALUE = Integer.MIN_VALUE;
    private transient List<IntegerParameterListener> listeners = new LinkedList<IntegerParameterListener>();
    private Integer maximum;
    private Integer minimum;

    public IntegerParameter(String name, String label, String description, Integer defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Integer maximum, Integer minimum) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public void addIntegerParameterListener(IntegerParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    @Override
    public Object getExpressionValue() {
        Integer value = (Integer)this.getValue();
        if (value == null) {
            return null;
        }
        return new Double(value.intValue());
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue != null) {
            Integer value;
            try {
                int intValue = Integer.parseInt(parameterValue);
                value = new Integer(intValue);
            }
            catch (NumberFormatException e) {
                throw new ParseException(e, LNG.get((String)"csbase.logic.algorithms.parameters.InvalidToInteger"), parameterValue, this);
            }
            this.setValue(value);
        } else {
            this.setValue(null);
        }
    }

    public boolean setMaximum(Integer maximum) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MaxLessThanMin"));
        }
        if (this.maximum == null && maximum == null) {
            return false;
        }
        if (this.maximum != null && this.maximum.equals(maximum)) {
            return false;
        }
        this.maximum = maximum;
        this.updateValidator();
        for (IntegerParameterListener listener : this.listeners) {
            listener.maximumWasChanged(this);
        }
        return true;
    }

    public boolean setMinimum(Integer minimum) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MinGreaterThenMax"));
        }
        if (this.minimum == null && minimum == null) {
            return false;
        }
        if (this.minimum != null && this.minimum.equals(minimum)) {
            return false;
        }
        this.minimum = minimum;
        this.updateValidator();
        for (IntegerParameterListener listener : this.listeners) {
            listener.minimumWasChanged(this);
        }
        return true;
    }

    private void updateValidator() {
        IntegerParameterValidator validator = (IntegerParameterValidator)this.getParameterValidator();
        validator.setMaximum(this.maximum);
        validator.setMinimum(this.minimum);
    }

    public IntegerParameterValidator createParameterValidator() {
        return new IntegerParameterValidator(this.isOptional(), this.maximum, this.minimum);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<IntegerParameterListener>();
    }

    @Override
    public void setJSONValue(Object value) {
        this.setValue((Integer)value);
    }
}

