/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.SyncRemoteFileChannel;
import java.io.IOException;
import java.io.OutputStream;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;

public class RemoteFileOutputStream
extends OutputStream {
    private byte[] id = null;
    private SyncRemoteFileChannel channel = null;
    private long position = 0L;

    @Override
    public void close() throws IOException {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.setSize(this.position);
            this.channel.close();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.id = null;
        this.channel = null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(int b) throws IOException {
        byte[] src = new byte[]{(byte)(b & 0xFF)};
        this.write(src);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.channel.syncWrite(b, off, len, this.position);
            this.position += (long)len;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public RemoteFileOutputStream(RemoteFileChannelInfo info) throws IOException {
        this.id = info.getIdentifier();
        this.channel = new SyncRemoteFileChannel(info);
        try {
            this.channel.open(true);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public RemoteFileOutputStream(byte[] id, SyncRemoteFileChannel channel) {
        this.id = id;
        this.channel = channel;
    }

    public String toString() {
        return LNG.get((String)"csbase.logic.RemoteFileOutputStreamTo") + new String(this.id);
    }
}

