/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.parameters.AbstractFileParameter;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.URLProtocol;
import csbase.logic.algorithms.parameters.URLProtocolConverter;
import csbase.logic.algorithms.parameters.validators.URLParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public abstract class URLParameter
extends AbstractFileParameter {
    private static final String PROTOCOL = ".protocol";
    private static final String HOST = ".host";
    private String localization;
    private EnumSet<URLProtocol> allowedProtocols;

    public URLParameter(String name, String label, String description, FileURLValue defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String localization, String[] fileTypes, FileParameterMode mode, FileParameterPipeAcceptance usesPipe, boolean mustExist, EnumSet<URLProtocol> allowedProtocols) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, fileTypes, mode, usesPipe, mustExist);
        if (mode == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "mode"));
        }
        this.localization = localization;
        this.allowedProtocols = allowedProtocols;
    }

    public String getLocalization() {
        return this.localization;
    }

    public EnumSet<URLProtocol> getAllowedProtocols() {
        return this.allowedProtocols;
    }

    public URLProtocol getDefaultProtocol() {
        if (this.allowedProtocols.size() == 0) {
            return FileURLValue.DEFAULT_PROTOCOL;
        }
        return (URLProtocol)((Object)this.allowedProtocols.iterator().next());
    }

    public URLParameterValidator createParameterValidator() {
        return new URLParameterValidator(this.isOptional());
    }

    @Override
    public Map<String, Object> exportValue() {
        if (this.getValue() == null) {
            return new HashMap<String, Object>();
        }
        LinkedList exportableValues = new LinkedList();
        HashMap<String, String> exportableValue = new HashMap<String, String>();
        FileURLValue value = (FileURLValue)this.getValue();
        exportableValue.put(".path", value.getPath());
        exportableValue.put(".type", value.getType());
        URLProtocol protocol = value.getProtocol();
        if (protocol != null) {
            exportableValue.put(PROTOCOL, protocol.getType());
        }
        exportableValue.put(HOST, value.getHost());
        exportableValues.add(Collections.unmodifiableMap(exportableValue));
        HashMap result = new HashMap();
        result.put(this.getName(), Collections.unmodifiableCollection(exportableValues));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        Collection exportableValues = (Collection)parameterValues.get(this.getName());
        if (exportableValues == null || exportableValues.isEmpty()) {
            this.setValue(null);
            return;
        }
        Map exportableValue = (Map)exportableValues.iterator().next();
        String path = (String)exportableValue.get(".path");
        String type = (String)exportableValue.get(".type");
        String protocolName = (String)exportableValue.get(PROTOCOL);
        String host = (String)exportableValue.get(HOST);
        if (protocolName != null) {
            try {
                URLProtocol protocol = new URLProtocolConverter().valueOf(protocolName);
                this.setValue(new FileURLValue(path, type, protocol, host));
                return;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Protocolo " + protocolName + " inv\u00e1lido");
            }
        }
        this.setValue(new FileURLValue(path, type));
    }

    @Override
    public String getCommandValue(CommandLineContext context) {
        FileURLValue file = (FileURLValue)this.getValue();
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        URLProtocol protocol = file.getProtocol();
        if (!path.startsWith("$")) {
            char fileSeparator = context.getFileSeparator();
            path = file.getPath(fileSeparator);
            switch (protocol) {
                case PROJECT: {
                    String filePath = file.getPath(fileSeparator);
                    if (filePath.startsWith("/")) {
                        filePath = filePath.substring(1);
                    }
                    path = CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, filePath, fileSeparator);
                    break;
                }
                default: {
                    String commandValue = protocol.getCommandValue();
                    if (commandValue == null) break;
                    path = commandValue + path;
                }
            }
        }
        String f = "%s %s=%s";
        return String.format(f, path, this.getLocalization(), protocol.getType());
    }

    @Override
    public String getValueAsText() {
        FileURLValue file = (FileURLValue)this.getValue();
        return FileURLValue.getStringValue(file);
    }

    @Override
    public void setValueAsText(String parameterValue) {
        FileURLValue value = FileURLValue.getURLFromString(this.mode, parameterValue);
        this.setValue(value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList();
    }

    @Override
    public void setJSONValue(Object value) {
        this.setValueAsText((String)value);
    }
}

