/**
 * $Id$
 */
package csbase.logic;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ClientRemoteLocator;
import tecgraf.javautils.core.lng.LNG;

/**
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class ApplicationPermission extends ChoicePermission {

  /** Identificador do nico conjunto de opes desta permisso. */
  private static final String APPLICATIONS = "APPLICATIONS";

  /** String que representa a marcao de todos */
  private static final String ALL = "#####";

  /**
   * Construtor.
   */
  public ApplicationPermission() {
    super();
  }

  /**
   * Construtor.
   * 
   * @param name Nome da permisso.
   * @param description Descrio da permisso.
   * @param attributes Mapa dos atributos desta permisso e seus respectivos
   *        valores.
   */
  public ApplicationPermission(String name, String description,
    Map<?, ?> attributes) {
    super(name, description, attributes);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, Object> getDomain() {
    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();

    map.put(APPLICATIONS, true);

    return map;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, Object> getRange(String attribute) throws Exception {

    LinkedHashMap<String, Object> range = new LinkedHashMap<String, Object>();

    Hashtable<String, ApplicationRegistry> applicationRegistries =
      ClientRemoteLocator.applicationService.getApplicationRegistries();

    Set<String> appIds = applicationRegistries.keySet();
    //inclui a opo ALL
    range.put(LNG.get(getClass().getName() + ".types.all"), ALL);
    for (String id : appIds) {
      ApplicationRegistry registry = applicationRegistries.get(id);
      if (!range.containsKey(registry.getApplicationName(LNG.getLocale()))) {
        range.put(registry.getApplicationName(LNG.getLocale()), id);
      }
      else {
        //Se h nomes conflitantes, os nomes tem de passar a ter o id da app entre parntesis
        String oldId = (String) range.remove(registry.getApplicationName(LNG
          .getLocale()));
        range.put(formatRangeKey(oldId, registry.getApplicationName(LNG
          .getLocale())), oldId);
        range.put(formatRangeKey(id, registry.getApplicationName(LNG
          .getLocale())), id);
      }
    }

    return range;
  }

  /**
   * Formata a string que ser utilizada como chave do mapa de range, e tambm
   * ser utilizada para a exibio da opo da aplicao.
   * 
   * @param appId o id da aplicao.
   * @param appName o nome da aplicao.
   * @return a chave formatada.
   */
  private String formatRangeKey(String appId, String appName) {
    return appName + " (" + appId + ")";
  }

  /**
   * Indica se um usurio tem permisso de uso de uma aplicao.
   * 
   * @param user o usurio.
   * @param appId o id da aplicao.
   * @return true se tem permisso, false caso contrrio.
   * @throws Exception
   */
  public static boolean userHasPermission(User user, String appId)
    throws Exception {

    //Usurios admins tem de poder ver sempre, para que seja possvel criar a permisso.
    if (user.isAdmin()) {
      return true;
    }

    Vector<Object> permissionIds = user.getAllPermissionIds();
    Set<ApplicationPermission> permissions =
      new HashSet<ApplicationPermission>();
    for (Object object : permissionIds) {
      Permission p = Permission.getPermission(object);
      if (p != null && p instanceof ApplicationPermission && !permissions
        .contains(p)) {
        //Cast  seguro pois esse mapa  criado desta forma pelo ancestral desta classe.
        @SuppressWarnings("unchecked")
        List<Object> applications = (List<Object>) ((ApplicationPermission) p)
          .getAttributes().get(APPLICATIONS);
        if (applications.contains(ALL) || applications.contains(appId)) {
          return true;
        }
      }
    }
    return false;

  }

}
