/**
 * $Id$
 */
package csbase.logic;

import java.io.IOException;

/**
 * Interface que define que um ClientFile pode ser copiado.
 *
 * @author Tecgraf/PUC-Rio
 * @param <T> O tipo especfico do arquivo.
 */
public interface CopyableFile<T extends ClientFile> {

  /**
   * Faz uma cpia deste arquivo mantendo o lastModifiedDate.
   *
   * @param targetDir o diretrio destino da cpia.
   * @return a cpia do arquivo.
   * @throws IOException
   */
  public T copy(T targetDir) throws IOException;

}
